/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspaceDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceChildNodesDataCache
extends LinkedHashMap<String, List<NodeData>> {
    public static int MAX_SIZE = 500;
    protected int maxSize = MAX_SIZE;
    protected WorkspaceDataCache relatedCache = null;

    WorkspaceChildNodesDataCache(WorkspaceDataCache relatedCache, int maxSize) {
        this.relatedCache = relatedCache;
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, List<NodeData>> eldest) {
        if (this.size() > this.getMaxSize()) {
            try {
                List<NodeData> nodes = eldest.getValue();
                for (NodeData node : nodes) {
                    this.relatedCache.remove((Serializable)((Object)node.getQPath().getAsString()));
                    this.relatedCache.remove((Serializable)((Object)node.getUUID()));
                }
                return true;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error in " + this.getClass().getName() + ".removeEldestEntry(): " + ex.getMessage(), ex);
            }
        }
        return false;
    }

    public WorkspaceDataCache getRelatedCache() {
        return this.relatedCache;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

