/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspacePersistentDataManager
implements DataManager {
    protected static Log log = ExoLogger.getLogger((String)"jcr.WorkspacePersistentDataManager");
    protected WorkspaceDataContainer dataContainer;
    protected List<ItemsPersistenceListener> listeners;

    public WorkspacePersistentDataManager(WorkspaceDataContainer dataContainer) {
        this.dataContainer = dataContainer;
        this.listeners = new ArrayList<ItemsPersistenceListener>();
    }

    public void save(ItemDataChangesLog changesLog) throws RepositoryException {
        List changes = changesLog.getAllStates();
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            for (ItemState itemState : changes) {
                String path;
                ItemData itemObj = itemState.getData();
                if (!(itemObj instanceof TransientItemData)) continue;
                long start = System.currentTimeMillis();
                TransientItemData data = (TransientItemData)itemObj;
                int state = itemState.getState();
                if (log.isDebugEnabled() && !(path = data.getQPath().getAsString()).startsWith("[]:1[http://www.jcp.org/jcr/1.0]system:1")) {
                    log.debug((Object)("[" + this.dataContainer.getName() + "] save item: " + ItemState.nameFromValue((int)state) + " " + path + " " + data.getUUID()));
                }
                data.increasePersistedVersion();
                if (itemState.isAdded()) {
                    this.doAdd(data, con);
                } else if (itemState.isUpdated()) {
                    this.doUpdate(data, con);
                } else if (itemState.isDeleted()) {
                    this.doDelete(data, con);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(ItemState.nameFromValue((int)state) + " " + (System.currentTimeMillis() - start) + "ms, " + data.getQPath().getAsString()));
            }
            con.commit();
        }
        catch (InvalidItemStateException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (con.isOpened()) {
                con.rollback();
            }
        }
        this.notifySaveItems(changesLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemData getItemData(InternalQPath qpath) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            ItemData itemData = con.getItemData(qpath);
            return itemData;
        }
        finally {
            con.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemData getItemData(String uuid) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            ItemData itemData = con.getItemData(uuid);
            return itemData;
        }
        finally {
            con.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyData> getReferencesData(String uuid) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List allRefs = con.getReferencesData(uuid);
            ArrayList<PropertyData> refProps = new ArrayList<PropertyData>();
            for (int i = 0; i < allRefs.size(); ++i) {
                PropertyData ref = (PropertyData)allRefs.get(i);
                if (ref.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH, false)) continue;
                refProps.add(ref);
            }
            ArrayList<PropertyData> arrayList = refProps;
            return arrayList;
        }
        finally {
            con.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List childNodes = con.getChildNodesData(nodeData);
            List list = childNodes != null ? childNodes : new ArrayList();
            return list;
        }
        finally {
            con.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            List childProperties = con.getChildPropertiesData(nodeData);
            List list = childProperties != null ? childProperties : new ArrayList();
            return list;
        }
        finally {
            con.rollback();
        }
    }

    public AccessControlList getACL(InternalQPath qpath) throws RepositoryException {
        ItemData data = this.getItemData(qpath);
        if (data != null && data.isNode()) {
            return ((NodeData)data).getACL();
        }
        return null;
    }

    protected void doDelete(TransientItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        block3: {
            try {
                if (con.getItemData(item.getUUID()) == null) {
                    throw new InvalidItemStateException("(delete) Item " + item.getQPath().getAsString() + " " + item.getUUID() + " not found. Probably was deleted by another session ");
                }
            }
            catch (PrimaryTypeNotFoundException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)e.getMessage());
            }
        }
        con.delete((ItemData)item);
    }

    protected void doUpdate(TransientItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        ItemData existed = con.getItemData(item.getUUID());
        if (existed == null) {
            ItemData samePathItem = con.getItemData(item.getQPath());
            if (samePathItem == null) {
                throw new InvalidItemStateException("(update) Item " + item.getQPath().getAsString() + " not found. Probably was deleted by another session");
            }
            con.delete(samePathItem);
        }
        if (item.isNode()) {
            con.update((NodeData)item);
            NodeData existedNode = (NodeData)existed;
            if (existedNode.getQPath().getIndex() != item.getQPath().getIndex()) {
                con.reindex(existedNode, (NodeData)item);
            }
        } else {
            con.update((PropertyData)item);
        }
    }

    protected void doAdd(TransientItemData item, WorkspaceStorageConnection con) throws RepositoryException, InvalidItemStateException {
        ItemData parentItem;
        ItemData sameItem = con.getItemData(item.getQPath());
        if (sameItem != null && sameItem.isNode() == item.isNode()) {
            throw new InvalidItemStateException("Item " + item.getQPath().getAsString() + " (persisted version: " + sameItem.getPersistedVersion() + ") already exists in " + this.dataContainer.getName() + ". Probably was added by another session " + sameItem.getUUID());
        }
        if (item.isNode() && item.getParentUUID() != null && (parentItem = con.getItemData(item.getParentUUID())) == null) {
            throw new InvalidItemStateException("Parent for item " + item.getQPath().getAsString() + " " + item.getUUID() + " (persisted version: " + item.getPersistedVersion() + ") does not exists in " + this.dataContainer.getName() + ". Probably was deleted by another session.");
        }
        if (item.isNode()) {
            con.add((NodeData)item);
        } else {
            con.add((PropertyData)item);
        }
    }

    public Calendar getCurrentTime() {
        return this.dataContainer.getCurrentTime();
    }

    public void addItemPersistenceListener(ItemsPersistenceListener listener) {
        this.listeners.add(listener);
        log.info((Object)("Workspace Data manager of '" + this.dataContainer.getName() + "' registered listener: " + listener));
    }

    protected void notifySaveItems(ItemDataChangesLog changesLog) {
        for (ItemsPersistenceListener listener : this.listeners) {
            listener.onSaveItems(changesLog);
        }
    }
}

