/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.replication;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.log.ExoLogger;

public class WorkspaceDataManagerProxy
implements ItemDataKeeper {
    protected static Log log = ExoLogger.getLogger((String)"jcr.WorkspaceDataManagerProxy");
    private List<ItemsPersistenceListener> listeners = new ArrayList<ItemsPersistenceListener>();

    public WorkspaceDataManagerProxy(CacheableWorkspaceDataManager dataManager, SearchIndex searchIndex) {
        this.listeners.add((ItemsPersistenceListener)dataManager.getCache());
        if (searchIndex != null) {
            this.listeners.add(searchIndex);
        }
        log.info((Object)"WorkspaceDataManagerProxy is instantiated");
    }

    public void save(ItemDataChangesLog changesLog) throws InvalidItemStateException, UnsupportedOperationException, RepositoryException {
        for (ItemsPersistenceListener listener : this.listeners) {
            listener.onSaveItems(changesLog);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ChangesLog sent to " + this.listeners));
        }
    }
}

