/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.WorkspaceStorageDataManagerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalWorkspaceStorageDataManagerProxy
implements WorkspaceStorageDataManagerProxy {
    protected final LocalWorkspaceDataManagerStub storageDataManager;
    protected final ValueFactoryImpl valueFactory;

    public LocalWorkspaceStorageDataManagerProxy(LocalWorkspaceDataManagerStub storageDataManager, ValueFactoryImpl valueFactory) {
        this.storageDataManager = storageDataManager;
        this.valueFactory = valueFactory;
    }

    public void save(ItemDataChangesLog changes) throws InvalidItemStateException, UnsupportedOperationException, RepositoryException {
        ArrayList<ItemState> states = new ArrayList<ItemState>(changes.getSize());
        for (ItemState change : changes.getAllStates()) {
            states.add(new ItemState((ItemData)this.copyItemData(change.getData()), change.getState(), change.isEventFire(), change.getAncestorToSave(), change.isInternalCreated()));
        }
        this.storageDataManager.save(new ItemDataChangesLog(states, changes.getSessionId()));
    }

    public ItemData getItemData(InternalQPath path) throws RepositoryException {
        return this.copyItemData(this.storageDataManager.getItemData(path));
    }

    public ItemData getItemData(String uuid) throws RepositoryException {
        return this.copyItemData(this.storageDataManager.getItemData(uuid));
    }

    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException {
        return this.copyNodes(this.storageDataManager.getChildNodesData(parent));
    }

    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException {
        return this.copyProperties(this.storageDataManager.getChildPropertiesData(parent));
    }

    public List<PropertyData> getReferencesData(String uuid) throws RepositoryException {
        return this.copyProperties(this.storageDataManager.getReferencesData(uuid));
    }

    public AccessControlList getACL(InternalQPath path) throws RepositoryException {
        AccessControlList acl = this.storageDataManager.getACL(path);
        return new AccessControlList(acl.getOwner(), acl.getPermissionEntries());
    }

    @Override
    public Calendar getCurrentTime() {
        return this.storageDataManager.getCurrentTime();
    }

    private TransientItemData copyItemData(ItemData item) throws RepositoryException {
        if (item == null) {
            return null;
        }
        if (item.isNode()) {
            NodeData node = (NodeData)item;
            AccessControlList acl = node.getACL();
            if (acl == null) {
                acl = this.getACL(node.getQPath());
            }
            return new TransientNodeData(node.getQPath(), node.getUUID(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentUUID(), acl);
        }
        PropertyData prop = (PropertyData)item;
        TransientPropertyData newData = new TransientPropertyData(prop.getQPath(), prop.getUUID(), prop.getPersistedVersion(), prop.getType(), prop.getParentUUID(), prop.isMultiValued());
        ArrayList<TransientValueData> values = null;
        if (prop.getValues() != null) {
            values = new ArrayList<TransientValueData>();
            for (ValueData val : prop.getValues()) {
                values.add(((AbstractValueData)val).createTransientCopy());
            }
        }
        newData.setValues(values);
        return newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeData> copyNodes(List<NodeData> childNodes) throws RepositoryException {
        LinkedList<NodeData> copyOfChildsNodes = new LinkedList<NodeData>();
        List<NodeData> list = childNodes;
        synchronized (list) {
            for (NodeData nodeData : childNodes) {
                copyOfChildsNodes.add((NodeData)this.copyItemData((ItemData)nodeData));
            }
        }
        return copyOfChildsNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PropertyData> copyProperties(List<PropertyData> traverseProperties) throws RepositoryException {
        LinkedList<PropertyData> copyOfChildsProperties = new LinkedList<PropertyData>();
        List<PropertyData> list = traverseProperties;
        synchronized (list) {
            for (PropertyData nodeProperty : traverseProperties) {
                copyOfChildsProperties.add((PropertyData)this.copyItemData((ItemData)nodeProperty));
            }
        }
        return copyOfChildsProperties;
    }
}

