/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SessionItemPool {
    private WeakHashMap<String, ItemImpl> items = new WeakHashMap();

    SessionItemPool() {
    }

    void remove(String uuid) {
        this.items.remove(uuid);
        System.gc();
    }

    void put(ItemImpl item) {
        if (!this.items.containsKey(item.getInternalUUID())) {
            this.items.put(item.getInternalUUID(), item);
        }
    }

    ItemImpl get(String uuid) {
        return this.items.get(uuid);
    }

    ItemImpl get(InternalQPath path) {
        for (ItemImpl item : this.items.values()) {
            if (!item.getInternalPath().equals((Object)path)) continue;
            return item;
        }
        return null;
    }

    List<NodeImpl> getChildNodes(String parentUUID) {
        ArrayList<NodeImpl> children = new ArrayList<NodeImpl>();
        for (ItemImpl item : this.items.values()) {
            if (!item.getParentUUID().equals(parentUUID) || !item.isNode()) continue;
            children.add((NodeImpl)item);
        }
        return children;
    }

    List<PropertyImpl> getChildProperties(String parentUUID) {
        ArrayList<PropertyImpl> children = new ArrayList<PropertyImpl>();
        for (ItemImpl item : this.items.values()) {
            if (!item.getParentUUID().equals(parentUUID) || !item.isNode()) continue;
            children.add((PropertyImpl)item);
        }
        return children;
    }
}

