/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.ext.action;

import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.command.action.ActionCatalog;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.ext.action.ActionConfiguration;
import org.exoplatform.services.jcr.impl.ext.action.AddActionsPlugin;
import org.exoplatform.services.jcr.impl.ext.action.SessionEventMatcher;
import org.exoplatform.services.log.ExoLogger;

public class SessionActionCatalog
extends ActionCatalog {
    private static Log log = ExoLogger.getLogger((String)"jcr.SessionActionCatalog");
    private LocationFactory locFactory;

    public SessionActionCatalog(RepositoryService repService) throws RepositoryException, RepositoryConfigurationException {
        RepositoryImpl rep = (RepositoryImpl)repService.getRepository();
        this.locFactory = rep.getLocationFactory();
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddActionsPlugin) {
            AddActionsPlugin cplugin = (AddActionsPlugin)plugin;
            for (ActionConfiguration ac : cplugin.getActions()) {
                try {
                    SessionEventMatcher matcher = new SessionEventMatcher(SessionActionCatalog.getEventTypes(ac.getEventTypes()), this.getPaths(ac.getPath()), ac.isDeep(), this.getNames(ac.getNodeType()), this.getNames(ac.getParentNodeType()), this.getWorkspaces(ac.getWorkspace()));
                    Action action = (Action)Class.forName(ac.getActionClassName()).newInstance();
                    this.addAction(matcher, action);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String[] getWorkspaces(String workspaces) throws RepositoryException {
        if (workspaces == null) {
            return null;
        }
        return workspaces.split(",");
    }

    private InternalQPath[] getPaths(String paths) throws RepositoryException {
        if (paths == null) {
            return null;
        }
        String[] pathList = paths.split(",");
        InternalQPath[] qpaths = new InternalQPath[pathList.length];
        for (int i = 0; i < pathList.length; ++i) {
            qpaths[i] = this.locFactory.parseAbsPath(pathList[i]).getInternalPath();
        }
        return qpaths;
    }

    private InternalQName[] getNames(String names) throws RepositoryException {
        if (names == null) {
            return null;
        }
        String[] nameList = names.split(",");
        InternalQName[] qnames = new InternalQName[nameList.length];
        for (int i = 0; i < nameList.length; ++i) {
            qnames[i] = this.locFactory.parseJCRName(nameList[i]).getInternalName();
        }
        return qnames;
    }

    private static int getEventTypes(String names) {
        if (names == null) {
            return -1;
        }
        String[] nameList = names.split(",");
        int res = 0;
        for (String name : nameList) {
            if (name.equalsIgnoreCase("addNode")) {
                res |= 1;
                continue;
            }
            if (name.equalsIgnoreCase("addProperty")) {
                res |= 4;
                continue;
            }
            if (name.equalsIgnoreCase("changeProperty")) {
                res |= 0x10;
                continue;
            }
            if (name.equalsIgnoreCase("addMixin")) {
                res |= 0x100;
                continue;
            }
            if (name.equalsIgnoreCase("removeProperty")) {
                res |= 8;
                continue;
            }
            if (name.equalsIgnoreCase("removeNode")) {
                res |= 2;
                continue;
            }
            if (name.equalsIgnoreCase("removeMixin")) {
                res |= 0x200;
                continue;
            }
            if (name.equalsIgnoreCase("lock")) {
                res |= 0x400000;
                continue;
            }
            if (name.equalsIgnoreCase("unlock")) {
                res |= 0x800000;
                continue;
            }
            if (name.equalsIgnoreCase("checkin")) {
                res |= 0x2000;
                continue;
            }
            if (name.equalsIgnoreCase("checkout")) {
                res |= 0x4000;
                continue;
            }
            log.error((Object)("Unknown event type '" + name + "' ignored"));
        }
        return res;
    }
}

