/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.ext.action;

import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.command.action.ActionCatalog;
import org.exoplatform.services.command.action.Condition;
import org.exoplatform.services.ext.action.InvocationContext;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;

public class SessionActionInterceptor {
    private final ActionCatalog catalog;
    private final ExoContainer container;

    public SessionActionInterceptor(ActionCatalog catalog, ExoContainer container) {
        this.catalog = catalog;
        this.container = container;
    }

    public void postAddNode(NodeImpl node) {
        if (this.catalog == null) {
            return;
        }
        Condition conditions = new Condition();
        conditions.put((Object)"types", (Object)1);
        try {
            conditions.put((Object)"nodeTypes", (Object)((ExtendedNodeType)node.getPrimaryNodeType()).getQName());
            conditions.put((Object)"paths", (Object)node.getInternalPath());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        InvocationContext ctx = new InvocationContext();
        ctx.put((Object)"currentItem", (Object)node);
        ctx.put((Object)"exocontainer", (Object)this.container);
        ctx.put((Object)"event", (Object)1);
        this.launch(conditions, ctx);
    }

    public void preRemoveItem(NodeImpl parent, ItemImpl item) {
        Condition conditions = new Condition();
        int event = item.isNode() ? 2 : 8;
        conditions.put((Object)"types", (Object)event);
        try {
            conditions.put((Object)"nodeTypes", (Object)((ExtendedNodeType)parent.getPrimaryNodeType()).getQName());
            conditions.put((Object)"parentNodeTypes", (Object)parent.getAllNodeTypes());
            conditions.put((Object)"paths", (Object)item.getInternalPath());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        InvocationContext ctx = new InvocationContext();
        ctx.put((Object)"currentItem", (Object)item);
        ctx.put((Object)"exocontainer", (Object)this.container);
        ctx.put((Object)"event", (Object)event);
        this.launch(conditions, ctx);
    }

    public void postSetProperty(NodeImpl parentNode, PropertyImpl property, int state) {
        if (this.catalog == null || property == null) {
            return;
        }
        int event = -1;
        switch (state) {
            case 1: {
                event = 4;
                break;
            }
            case 2: {
                event = 16;
                break;
            }
            case 3: {
                event = 8;
                break;
            }
            default: {
                return;
            }
        }
        Condition conditions = new Condition();
        conditions.put((Object)"types", (Object)event);
        try {
            conditions.put((Object)"nodeTypes", (Object)((ExtendedNodeType)parentNode.getPrimaryNodeType()).getQName());
            conditions.put((Object)"parentNodeTypes", (Object)parentNode.getAllNodeTypes());
            conditions.put((Object)"paths", (Object)property.getInternalPath());
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        InvocationContext ctx = new InvocationContext();
        ctx.put((Object)"currentItem", (Object)property);
        ctx.put((Object)"exocontainer", (Object)this.container);
        ctx.put((Object)"event", (Object)event);
        this.launch(conditions, ctx);
    }

    public void postAddMixin(NodeImpl node, InternalQName mixinType) {
        if (this.catalog == null) {
            return;
        }
        Condition conditions = new Condition();
        conditions.put((Object)"types", (Object)256);
        conditions.put((Object)"nodeTypes", (Object)mixinType);
        try {
            conditions.put((Object)"parentNodeTypes", (Object)node.getAllNodeTypes());
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        conditions.put((Object)"paths", (Object)node.getInternalPath());
        InvocationContext ctx = new InvocationContext();
        ctx.put((Object)"currentItem", (Object)node);
        ctx.put((Object)"event", (Object)256);
        ctx.put((Object)"exocontainer", (Object)this.container);
        this.launch(conditions, ctx);
    }

    public void preRemoveMixin(NodeImpl node, InternalQName mixinType) {
        if (this.catalog == null) {
            return;
        }
        Condition conditions = new Condition();
        conditions.put((Object)"types", (Object)512);
        conditions.put((Object)"nodeTypes", (Object)mixinType);
        conditions.put((Object)"paths", (Object)node.getInternalPath());
        try {
            conditions.put((Object)"parentNodeTypes", (Object)node.getAllNodeTypes());
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        InvocationContext ctx = new InvocationContext();
        ctx.put((Object)"currentItem", (Object)node);
        ctx.put((Object)"event", (Object)512);
        ctx.put((Object)"exocontainer", (Object)this.container);
        this.launch(conditions, ctx);
    }

    protected final void launch(Condition conditions, InvocationContext context) {
        Set cond;
        if (conditions != null && this.catalog != null && (cond = this.catalog.getActions(conditions)) != null) {
            Iterator i = cond.iterator();
            while (i.hasNext()) {
                try {
                    ((Action)i.next()).execute((Context)context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void postLock(NodeImpl node) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        Condition conditions = new Condition();
        conditions.put((Object)"types", (Object)0x400000);
        conditions.put((Object)"nodeTypes", (Object)((ExtendedNodeType)node.getPrimaryNodeType()).getQName());
        conditions.put((Object)"parentNodeTypes", (Object)((NodeImpl)node.getParent()).getAllNodeTypes());
        conditions.put((Object)"paths", (Object)node.getInternalPath());
        InvocationContext ctx = new InvocationContext();
        ctx.put((Object)"currentItem", (Object)node);
        ctx.put((Object)"event", (Object)0x400000);
        ctx.put((Object)"exocontainer", (Object)this.container);
        this.launch(conditions, ctx);
    }

    public void postUnlock(NodeImpl node) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        Condition conditions = new Condition();
        conditions.put((Object)"types", (Object)0x800000);
        conditions.put((Object)"nodeTypes", (Object)((ExtendedNodeType)node.getPrimaryNodeType()).getQName());
        conditions.put((Object)"parentNodeTypes", (Object)((NodeImpl)node.getParent()).getAllNodeTypes());
        conditions.put((Object)"paths", (Object)node.getInternalPath());
        InvocationContext ctx = new InvocationContext();
        ctx.put((Object)"currentItem", (Object)node);
        ctx.put((Object)"event", (Object)0x800000);
        ctx.put((Object)"exocontainer", (Object)this.container);
        this.launch(conditions, ctx);
    }

    public void postCheckin(NodeImpl node) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        Condition conditions = new Condition();
        conditions.put((Object)"types", (Object)8192);
        conditions.put((Object)"nodeTypes", (Object)((ExtendedNodeType)node.getPrimaryNodeType()).getQName());
        conditions.put((Object)"parentNodeTypes", (Object)((NodeImpl)node.getParent()).getAllNodeTypes());
        conditions.put((Object)"paths", (Object)node.getInternalPath());
        InvocationContext ctx = new InvocationContext();
        ctx.put((Object)"currentItem", (Object)node);
        ctx.put((Object)"event", (Object)8192);
        ctx.put((Object)"exocontainer", (Object)this.container);
        this.launch(conditions, ctx);
    }

    public void postCheckout(NodeImpl node) throws RepositoryException {
        if (this.catalog == null) {
            return;
        }
        Condition conditions = new Condition();
        conditions.put((Object)"types", (Object)16384);
        conditions.put((Object)"nodeTypes", (Object)((ExtendedNodeType)node.getPrimaryNodeType()).getQName());
        conditions.put((Object)"parentNodeTypes", (Object)((NodeImpl)node.getParent()).getAllNodeTypes());
        conditions.put((Object)"paths", (Object)node.getInternalPath());
        InvocationContext ctx = new InvocationContext();
        ctx.put((Object)"currentItem", (Object)node);
        ctx.put((Object)"event", (Object)16384);
        ctx.put((Object)"exocontainer", (Object)this.container);
        this.launch(conditions, ctx);
    }
}

