/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CleanableFileStreamValueData;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.storage.jdbc.SQLExceptionHandler;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBCStorageConnection
extends DBConstants
implements WorkspaceStorageConnection {
    protected static Log log = ExoLogger.getLogger((String)"jcr.JDBCStorageConnection");
    protected PreparedStatement findItemById;
    protected PreparedStatement findItemByPath;
    protected PreparedStatement findChildPropertyByPath;
    protected PreparedStatement findDescendantNodes;
    protected PreparedStatement findDescendantProperties;
    protected PreparedStatement findReferences;
    protected PreparedStatement findValuesByPropertyId;
    protected PreparedStatement findValueByPropertyIdOrderNumber;
    protected PreparedStatement findNodesByParentId;
    protected PreparedStatement findPropertiesByParentId;
    protected PreparedStatement insertItem;
    protected PreparedStatement insertNode;
    protected PreparedStatement insertProperty;
    protected PreparedStatement insertReference;
    protected PreparedStatement insertValue;
    protected PreparedStatement updateItem;
    protected PreparedStatement updateItemPath;
    protected PreparedStatement updateNode;
    protected PreparedStatement updateProperty;
    protected PreparedStatement deleteItem;
    protected PreparedStatement deleteNode;
    protected PreparedStatement deleteProperty;
    protected PreparedStatement deleteReference;
    protected PreparedStatement deleteValue;
    protected final ValueStoragePluginProvider valueStorageProvider;
    protected final int maxBufferSize;
    protected final File swapDirectory;
    protected final FileCleaner swapCleaner;
    protected final DataSource dataSource;
    protected final Connection dbConnection;
    protected final String containerName;
    protected final SQLExceptionHandler exceptionHandler;

    protected JDBCStorageConnection(DataSource dataSource, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        this.dataSource = dataSource;
        this.valueStorageProvider = valueStorageProvider;
        this.maxBufferSize = maxBufferSize;
        this.swapDirectory = swapDirectory;
        this.swapCleaner = swapCleaner;
        this.containerName = containerName;
        this.dbConnection = dataSource.getConnection();
        if (this.dbConnection.getAutoCommit()) {
            this.dbConnection.setAutoCommit(false);
        }
        this.prepareQueries();
        this.prepareStatements();
        this.exceptionHandler = new SQLExceptionHandler(containerName, this);
    }

    public Connection getJdbcConnection() throws SQLException {
        return this.dbConnection;
    }

    protected abstract void prepareQueries() throws SQLException;

    protected abstract String getInternalId(String var1);

    protected abstract String getUuid(String var1);

    protected void checkIfOpened() throws IllegalStateException {
        if (!this.isOpened()) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    public boolean isOpened() {
        try {
            return !this.dbConnection.isClosed();
        }
        catch (SQLException e) {
            log.error((Object)e);
            return false;
        }
    }

    public final void rollback() throws IllegalStateException, RepositoryException {
        this.checkIfOpened();
        try {
            this.dbConnection.rollback();
            this.dbConnection.close();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public final void commit() throws IllegalStateException, RepositoryException {
        this.checkIfOpened();
        try {
            this.dbConnection.commit();
            this.dbConnection.close();
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void add(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            this.addNodeRecord(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node added " + data.getQPath().getAsString() + ", " + data.getUUID() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            log.error((Object)("Node add. Database error: " + e), (Throwable)e);
            this.exceptionHandler.handleAddException(e, (ItemData)data);
        }
    }

    public void add(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            ValueIOChannel channel;
            this.addPropertyRecord(data);
            if (data.getType() == 9) {
                try {
                    this.addReference(data);
                }
                catch (IOException e) {
                    throw new RepositoryException("Can't read REFERENCE property (" + data.getQPath() + " " + data.getUUID() + ") value: " + e.getMessage(), (Throwable)e);
                }
            }
            if ((channel = this.valueStorageProvider.getApplicableChannel(data)) != null) {
                channel.write(data.getUUID(), data.getValues());
                channel.close();
            } else {
                this.addValues(this.getInternalId(data.getUUID()), data.getValues());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property added " + data.getQPath().getAsString() + ", " + data.getUUID() + (data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data") + ", use channel " + channel));
            }
        }
        catch (IOException e) {
            log.error((Object)("Property add. IO error: " + e), (Throwable)e);
            this.exceptionHandler.handleAddException(e, (ItemData)data);
        }
        catch (SQLException e) {
            log.error((Object)("Property add. Database error: " + e), (Throwable)e);
            this.exceptionHandler.handleAddException(e, (ItemData)data);
        }
    }

    public void delete(ItemData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        String cid = this.getInternalId(data.getUUID());
        try {
            if (data.isNode()) {
                if (this.deleteNode(cid) <= 0) {
                    log.warn((Object)("Error state, the node (with sub-nodes) is not deleted " + data.getQPath().getAsString()));
                }
            } else if (this.deleteProperty(cid) <= 0) {
                log.warn((Object)("Error state, the property item is not deleted " + data.getQPath().getAsString()));
            }
            if (log.isDebugEnabled()) {
                if (data.isNode()) {
                    log.debug((Object)("Node deleted " + data.getQPath().getAsString() + ", " + data.getUUID() + ", " + ((NodeData)data).getPrimaryTypeName().getAsString()));
                } else {
                    log.debug((Object)("Property deleted " + data.getQPath().getAsString() + ", " + data.getUUID() + (((PropertyData)data).getValues() != null ? ", values count: " + ((PropertyData)data).getValues().size() : ", NULL data")));
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("Item remove. Database error: " + e), (Throwable)e);
            this.exceptionHandler.handleDeleteException(e, data);
        }
    }

    protected int deleteNode(String cid) throws SQLException {
        int nc;
        int deleted = 0;
        if (this.deleteNodeByUUID(cid) <= 0) {
            log.warn((Object)("Error state, the node actually not deleted " + cid));
        }
        if ((nc = this.deleteItemByUUID(cid)) <= 0) {
            log.warn((Object)("Error state, a item corresponding the node actually not deleted " + cid));
        }
        return deleted += nc;
    }

    protected int deleteProperty(String cid) throws SQLException, RepositoryException {
        PropertyData data = (PropertyData)this.getItemByUUID(cid);
        try {
            ValueIOChannel channel = this.valueStorageProvider.getApplicableChannel(data);
            if (channel != null) {
                channel.delete(data.getUUID());
                channel.close();
            } else {
                this.deleteValues(cid);
            }
            this.deleteReference(cid);
            if (this.deletePropertyByUUID(cid) <= 0) {
                log.warn((Object)("Error state, the property actually is not deleted " + cid));
            }
            return this.deleteItemByUUID(cid);
        }
        catch (IOException e) {
            this.exceptionHandler.handleDeleteException(e, (ItemData)data);
            return 0;
        }
    }

    public void doReindex(String itemUuid, String oldQPath, int indexDelimPos, int oldIndexLength, String newIndexStr) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException, SQLException {
        ResultSet dnrs = this.findDescendantNodes(itemUuid, oldQPath);
        class ItemId {
            private final String cid;
            private final String path;
            private final int version;

            ItemId(String cid, String path, int version) {
                this.cid = cid;
                this.path = path;
                this.version = version;
            }

            public String getCid() {
                return this.cid;
            }

            public String getPath() {
                return this.path;
            }

            public int getVersion() {
                return this.version;
            }
        }
        ArrayList<ItemId> descendantNodes = new ArrayList<ItemId>();
        while (dnrs.next()) {
            descendantNodes.add(new ItemId(dnrs.getString("ID"), dnrs.getString("PATH"), dnrs.getInt("VERSION")));
        }
        dnrs.close();
        for (ItemId item : descendantNodes) {
            String newDescPath = item.getPath().substring(0, indexDelimPos) + newIndexStr + item.getPath().substring(indexDelimPos + oldIndexLength);
            if (this.updateItemPathByUUID(newDescPath, item.getVersion() + 1, item.getCid()) <= 0) {
                log.warn((Object)("No nodes was updated during reindex " + item.getPath() + " -> " + newDescPath + ", uuid:" + item.getCid()));
                continue;
            }
            this.doReindex(item.getCid(), oldQPath, indexDelimPos, oldIndexLength, newIndexStr);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Reindex node " + item.getPath() + " -> " + newDescPath + ", " + item.getCid()));
        }
        ResultSet dprs = this.findDescendantProperties(itemUuid, oldQPath);
        ArrayList<ItemId> descendantProperties = new ArrayList<ItemId>();
        while (dprs.next()) {
            descendantProperties.add(new ItemId(dprs.getString("ID"), dprs.getString("PATH"), dprs.getInt("VERSION")));
        }
        dprs.close();
        for (ItemId item : descendantProperties) {
            String newDescPath = item.getPath().substring(0, indexDelimPos) + newIndexStr + item.getPath().substring(indexDelimPos + oldIndexLength);
            if (this.updateItemPathByUUID(newDescPath, item.getVersion() + 1, item.getCid()) <= 0) {
                log.warn((Object)("No nodes was updated during reindex " + item.getPath() + " -> " + newDescPath + ", uuid:" + item.getCid()));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Reindex property " + item.getPath() + " -> " + newDescPath + ", " + item.getCid()));
        }
    }

    public void reindex(NodeData oldData, NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            String cid = this.getInternalId(data.getUUID());
            String oldQPath = oldData.getQPath().getAsString();
            String newQPath = data.getQPath().getAsString();
            int indexDelimPos = oldQPath.lastIndexOf(":");
            if (newQPath.charAt(indexDelimPos) != ':') {
                throw new RepositoryException("Reindex. An old and a new node has a different locations in workspace. " + oldQPath + ", " + newQPath);
            }
            String newIndexStr = newQPath.substring(++indexDelimPos);
            int oldIndexLength = oldQPath.length() - indexDelimPos;
            if (this.updateItemPathByUUID(newQPath, data.getPersistedVersion() + 1, cid) <= 0) {
                log.warn((Object)("No nodes was updated during reindex " + oldQPath + " -> " + newQPath + ", uuid:" + cid));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Reindex root node " + oldQPath + " -> " + newQPath + ", " + cid + ", " + data.getPrimaryTypeName().getAsString()));
            }
            this.doReindex(cid, oldQPath, indexDelimPos, oldIndexLength, newIndexStr);
        }
        catch (RepositoryException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Node reindex. Database error: " + e), (Throwable)e);
            this.exceptionHandler.handleUpdateException(e, (ItemData)data);
        }
    }

    public void update(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            String cid = this.getInternalId(data.getUUID());
            this.updateItemVersionByUUID(data.getPersistedVersion(), cid);
            this.updateNodeOrderNumbByUUID(data.getOrderNumber(), cid);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Node updated " + data.getQPath().getAsString() + ", " + data.getUUID() + ", " + data.getPrimaryTypeName().getAsString()));
            }
        }
        catch (SQLException e) {
            log.error((Object)("Node update. Database error: " + e), (Throwable)e);
            this.exceptionHandler.handleUpdateException(e, (ItemData)data);
        }
    }

    public void update(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.checkIfOpened();
        try {
            String cid = this.getInternalId(data.getUUID());
            this.updateItemVersionByUUID(data.getPersistedVersion(), cid);
            this.updatePropertyTypeByUUID(data.getType(), cid);
            try {
                this.deleteReference(cid);
                if (data.getType() == 9) {
                    this.addReference(data);
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Can't update REFERENCE property (" + data.getQPath() + " " + data.getUUID() + ") value: " + e.getMessage(), (Throwable)e);
            }
            ValueIOChannel channel = this.valueStorageProvider.getApplicableChannel(data);
            if (channel != null) {
                channel.delete(data.getUUID());
                channel.write(data.getUUID(), data.getValues());
                channel.close();
            } else {
                this.deleteValues(cid);
                this.addValues(cid, data.getValues());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Property updated " + data.getQPath().getAsString() + ", " + data.getUUID() + (data.getValues() != null ? ", values count: " + data.getValues().size() : ", NULL data") + ", use channel " + channel));
            }
        }
        catch (IOException e) {
            log.error((Object)("Property update. IO error: " + e), (Throwable)e);
            this.exceptionHandler.handleUpdateException(e, (ItemData)data);
        }
        catch (SQLException e) {
            log.error((Object)("Property update. Database error: " + e), (Throwable)e);
            this.exceptionHandler.handleUpdateException(e, (ItemData)data);
        }
    }

    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet node = this.findChildNodesByParentUUID(this.getInternalId(parent.getUUID()));
            ArrayList<NodeData> childrens = new ArrayList<NodeData>();
            while (node.next()) {
                if (node.getString("NID") != null) {
                    childrens.add((NodeData)this.loadNodeRecord(node));
                    continue;
                }
                throw new RepositoryException("FATAL: Not found child node for parent " + parent.getQPath().getAsString() + ", but child item found " + node.getString("PATH") + " " + this.getUuid(node.getString("ID")));
            }
            return childrens;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
    }

    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet prop = this.findChildPropertiesByParentUUID(this.getInternalId(parent.getUUID()));
            ArrayList<PropertyData> children = new ArrayList<PropertyData>();
            while (prop.next()) {
                if (prop.getString("PID") != null) {
                    children.add((PropertyData)this.loadPropertyRecord(prop));
                    continue;
                }
                throw new RepositoryException("FATAL: Not found child property for parent " + parent.getQPath().getAsString() + ", but child item found " + prop.getString("PATH") + " " + this.getUuid(prop.getString("ID")));
            }
            return children;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
    }

    public ItemData getItemData(InternalQPath qPath) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        ResultSet item = null;
        try {
            item = this.findItemByPath(qPath.getAsString());
            if (item.next()) {
                ItemData itemData = this.itemData(item);
                return itemData;
            }
            ItemData itemData = null;
            return itemData;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
        finally {
            try {
                if (item != null) {
                    item.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)("getItemData() Error close resultset " + e.getMessage()));
            }
        }
    }

    public ItemData getItemData(String uuid) throws RepositoryException, IllegalStateException {
        return this.getItemByUUID(this.getInternalId(uuid));
    }

    public List<PropertyData> getReferencesData(String nodeUUID) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        try {
            ResultSet refProps = this.findReferences(this.getInternalId(nodeUUID));
            ArrayList<PropertyData> references = new ArrayList<PropertyData>();
            while (refProps.next()) {
                references.add((PropertyData)this.loadPropertyRecord(refProps));
            }
            return references;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RepositoryException((Throwable)e);
        }
    }

    protected ItemData getItemByUUID(String cid) throws RepositoryException, IllegalStateException {
        this.checkIfOpened();
        ResultSet item = null;
        try {
            item = this.findItemByUUID(cid);
            if (item.next()) {
                ItemData itemData = this.itemData(item);
                return itemData;
            }
            ItemData itemData = null;
            return itemData;
        }
        catch (SQLException e) {
            throw new RepositoryException("getItemData() error", (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("getItemData() error", (Throwable)e);
        }
        finally {
            try {
                if (item != null) {
                    item.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)("getItemData() Error close resultset " + e.getMessage()));
            }
        }
    }

    private ItemData itemData(ResultSet itemRecord) throws RepositoryException, SQLException, IOException {
        boolean isProperty;
        String id = itemRecord.getString("ID");
        boolean isNode = itemRecord.getString("NID") != null;
        boolean bl = isProperty = itemRecord.getString("PID") != null;
        if (isNode && isProperty) {
            throw new RepositoryException("FATAL: Item stored as node and as property " + itemRecord.getString("PATH") + " " + this.getUuid(id));
        }
        if (!isNode && !isProperty) {
            throw new RepositoryException("FATAL: Not found corresponding node nor property for item " + itemRecord.getString("PATH") + " " + this.getUuid(id));
        }
        if (isNode) {
            return this.loadNodeRecord(itemRecord);
        }
        return this.loadPropertyRecord(itemRecord);
    }

    protected final void prepareStatements() throws SQLException {
        this.findValuesByPropertyId = this.dbConnection.prepareStatement(this.FIND_VALUES_BY_PROPERTYID);
        this.findValueByPropertyIdOrderNumber = this.dbConnection.prepareStatement(this.FIND_VALUE_BY_PROPERTYID_OREDERNUMB);
        this.insertValue = this.dbConnection.prepareStatement(this.INSERT_VALUE);
        this.insertReference = this.dbConnection.prepareStatement(this.INSERT_REF);
    }

    protected PersistedNodeData loadNodeRecord(ResultSet item) throws RepositoryException, SQLException {
        AccessControlList acl;
        String cNID = item.getString("NID");
        String cNPARENTID = item.getString("NPARENT_ID");
        int cVERSION = item.getInt("VERSION");
        int cNORDERNUM = item.getInt("NORDER_NUM");
        InternalQPath qpath = InternalQPath.parse((String)item.getString("PATH"));
        InternalQPath ptPath = InternalQPath.makeChildPath((InternalQPath)qpath, (InternalQName)Constants.JCR_PRIMARYTYPE);
        ResultSet ptProp = this.findPropertyByPath(cNID, ptPath.getAsString());
        if (!ptProp.next()) {
            throw new PrimaryTypeNotFoundException("FATAL ERROR primary type record not found " + ptPath.getAsString() + ", parent id " + cNID + ", container " + this.containerName, ptPath);
        }
        ResultSet ptValue = this.findValuesByPropertyId(ptProp.getString("PID"));
        if (!ptValue.next()) {
            throw new RepositoryException("FATAL ERROR primary type value not found " + ptPath.getAsString() + ", id " + ptProp.getString("ID") + ", container " + this.containerName);
        }
        byte[] data = ptValue.getBytes("DATA");
        InternalQName ptName = InternalQName.parse((String)new String(data != null ? data : new byte[]{}));
        InternalQPath mtPath = InternalQPath.makeChildPath((InternalQPath)qpath, (InternalQName)Constants.JCR_MIXINTYPES);
        ResultSet mtProp = this.findPropertyByPath(cNID, mtPath.getAsString());
        InternalQName[] mixinNames = new InternalQName[]{};
        if (mtProp.next()) {
            ArrayList<byte[]> mts = new ArrayList<byte[]>();
            ResultSet mtValues = this.findValuesByPropertyId(mtProp.getString("PID"));
            while (mtValues.next()) {
                mts.add(mtValues.getBytes("DATA"));
            }
            mixinNames = new InternalQName[mts.size()];
            for (int i = 0; i < mts.size(); ++i) {
                mixinNames[i] = InternalQName.parse((String)new String((byte[])mts.get(i)));
            }
        }
        if (this.isAccessControllable(mixinNames)) {
            InternalQPath ownerPath = InternalQPath.makeChildPath((InternalQPath)qpath, (InternalQName)Constants.EXO_OWNER);
            PropertyData ownerData = (PropertyData)this.getItemData(ownerPath);
            InternalQPath permPath = InternalQPath.makeChildPath((InternalQPath)qpath, (InternalQName)Constants.EXO_PERMISSIONS);
            PropertyData permData = (PropertyData)this.getItemData(permPath);
            acl = new AccessControlList(ownerData, permData);
        } else {
            acl = qpath.equals((Object)Constants.ROOT_PATH) ? new AccessControlList() : null;
        }
        return new PersistedNodeData(this.getUuid(cNID), qpath, this.getUuid(cNPARENTID), cVERSION, cNORDERNUM, ptName, mixinNames, acl);
    }

    private boolean isAccessControllable(InternalQName[] mixinNames) {
        for (int i = 0; i < mixinNames.length; ++i) {
            if (!mixinNames[i].getAsString().equals("[http://www.exoplatform.com/jcr/exo/1.0]accessControllable") && !mixinNames[i].getAsString().equals("[http://www.exoplatform.com/jcr/exo/1.0]privilegeable")) continue;
            return true;
        }
        return false;
    }

    protected PersistedPropertyData loadPropertyRecord(ResultSet item) throws RepositoryException, SQLException, IOException {
        List<Object> values = new ArrayList();
        InternalQPath path = InternalQPath.parse((String)item.getString("PATH"));
        String cid = item.getString("PID");
        String uuid = this.getUuid(cid);
        PersistedPropertyData pdata = new PersistedPropertyData(uuid, path, this.getUuid(item.getString("PPARENT_ID")), item.getInt("VERSION"), item.getInt("PTYPE"), item.getBoolean("PMULTIVALUED"));
        ValueIOChannel channel = this.valueStorageProvider.getApplicableChannel((PropertyData)pdata);
        if (channel != null) {
            values = channel.read(uuid, this.maxBufferSize);
            channel.close();
        } else {
            values = this.readValues(cid);
        }
        pdata.setValues(values);
        return pdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ValueData> readValues(String cid) throws IOException {
        ArrayList<ValueData> data = new ArrayList<ValueData>();
        try {
            ResultSet valueRecords = this.findValuesByPropertyId(cid);
            try {
                while (valueRecords.next()) {
                    int orderNum = valueRecords.getInt("ORDER_NUM");
                    ValueData vdata = this.readValueData(cid, orderNum);
                    data.add(vdata);
                }
            }
            finally {
                valueRecords.close();
            }
        }
        catch (SQLException e) {
            String msg = "Can't read value data of property with id " + cid + ", error:" + e;
            log.error((Object)msg, (Throwable)e);
            throw new IOException(msg);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData readValueData(String cid, int orderNumber) throws SQLException, IOException {
        byte[] buffer = new byte[]{};
        byte[] spoolBuffer = new byte[8192];
        int len = 0;
        OutputStream out = null;
        File spoolFile = null;
        ResultSet valueResultSet = null;
        try {
            InputStream in;
            valueResultSet = this.findValueByPropertyIdOrderNumber(cid, orderNumber);
            if (valueResultSet.next() && (in = valueResultSet.getBinaryStream("DATA")) != null) {
                int read;
                while ((read = in.read(spoolBuffer)) > 0) {
                    if (out != null) {
                        out.write(spoolBuffer, 0, read);
                        len += read;
                        continue;
                    }
                    if (len + read > this.maxBufferSize) {
                        spoolFile = new File(this.swapDirectory, cid + orderNumber);
                        out = new FileOutputStream(spoolFile);
                        out.write(buffer, 0, len);
                        out.write(spoolBuffer, 0, read);
                        buffer = null;
                        len += read;
                        continue;
                    }
                    byte[] newBuffer = new byte[len + read];
                    System.arraycopy(buffer, 0, newBuffer, 0, len);
                    System.arraycopy(spoolBuffer, 0, newBuffer, len, read);
                    buffer = newBuffer;
                    len += read;
                }
            }
        }
        finally {
            if (valueResultSet != null) {
                valueResultSet.close();
            }
            if (out != null) {
                out.close();
            }
        }
        if (buffer == null) {
            return new CleanableFileStreamValueData(spoolFile, orderNumber, false, this.swapCleaner);
        }
        return new ByteArrayPersistedValueData(buffer, orderNumber);
    }

    protected void addValues(String cid, List<ValueData> data) throws IOException, SQLException {
        if (data == null) {
            log.warn((Object)("List of values data is NULL. Check JCR logic. PropertyId: " + this.getUuid(cid)));
            return;
        }
        for (int i = 0; i < data.size(); ++i) {
            this.addValueRecord(cid, data.get(i), i);
        }
    }

    protected void addValueRecord(String cid, ValueData data, int orderNumber) throws SQLException, IOException {
        InputStream stream = null;
        int streamLength = 0;
        if (data.isByteArray()) {
            byte[] dataBytes = data.getAsByteArray();
            stream = new ByteArrayInputStream(dataBytes);
            streamLength = dataBytes.length;
        } else {
            stream = data.getAsStream();
            streamLength = stream.available();
        }
        if (this.insertValue == null) {
            this.insertValue = this.dbConnection.prepareStatement(this.INSERT_VALUE);
        }
        this.insertValue.setBinaryStream(1, stream, streamLength);
        data.setOrderNumber(orderNumber);
        this.insertValue.setInt(2, data.getOrderNumber());
        this.insertValue.setString(3, cid);
        this.insertValue.executeUpdate();
    }

    protected void deleteValues(String cid) throws SQLException {
        if (this.deleteValue == null) {
            this.deleteValue = this.dbConnection.prepareStatement(this.DELETE_VALUE);
        }
        this.deleteValue.setString(1, cid);
        this.deleteValue.executeUpdate();
    }

    protected ResultSet findValuesByPropertyId(String cid) throws SQLException {
        if (this.findValuesByPropertyId == null) {
            this.findValuesByPropertyId = this.dbConnection.prepareStatement(this.FIND_VALUES_BY_PROPERTYID);
        }
        this.findValuesByPropertyId.setString(1, cid);
        return this.findValuesByPropertyId.executeQuery();
    }

    protected ResultSet findValueByPropertyIdOrderNumber(String cid, int orderNumb) throws SQLException {
        if (this.findValueByPropertyIdOrderNumber == null) {
            this.findValueByPropertyIdOrderNumber = this.dbConnection.prepareStatement(this.FIND_VALUE_BY_PROPERTYID_OREDERNUMB);
        }
        this.findValueByPropertyIdOrderNumber.setString(1, cid);
        this.findValueByPropertyIdOrderNumber.setInt(2, orderNumb);
        return this.findValueByPropertyIdOrderNumber.executeQuery();
    }

    protected abstract void addNodeRecord(NodeData var1) throws SQLException;

    protected abstract void addPropertyRecord(PropertyData var1) throws SQLException;

    protected abstract ResultSet findItemByPath(String var1) throws SQLException;

    protected abstract ResultSet findItemByUUID(String var1) throws SQLException;

    protected abstract ResultSet findPropertyByPath(String var1, String var2) throws SQLException;

    protected abstract ResultSet findChildNodesByParentUUID(String var1) throws SQLException;

    protected abstract ResultSet findChildPropertiesByParentUUID(String var1) throws SQLException;

    protected abstract ResultSet findDescendantNodes(String var1, String var2) throws SQLException;

    protected abstract ResultSet findDescendantProperties(String var1, String var2) throws SQLException;

    protected abstract void addReference(PropertyData var1) throws SQLException, IOException;

    protected abstract void deleteReference(String var1) throws SQLException;

    protected abstract ResultSet findReferences(String var1) throws SQLException;

    protected abstract int deleteItemByUUID(String var1) throws SQLException;

    protected abstract int deleteNodeByUUID(String var1) throws SQLException;

    protected abstract int deletePropertyByUUID(String var1) throws SQLException;

    protected abstract int updateItemVersionByUUID(int var1, String var2) throws SQLException;

    protected abstract int updateItemPathByUUID(String var1, int var2, String var3) throws SQLException;

    protected abstract int updateNodeOrderNumbByUUID(int var1, String var2) throws SQLException;

    protected abstract int updatePropertyTypeByUUID(int var1, String var2) throws SQLException;
}

