/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;

public class SQLExceptionHandler {
    private final String containerName;
    private final JDBCStorageConnection conn;

    SQLExceptionHandler(String containerName, JDBCStorageConnection conn) {
        this.containerName = containerName;
        this.conn = conn;
    }

    protected String handleAddException(Exception e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String itemInfo;
        String message;
        block12: {
            message = "[" + this.containerName + "] ";
            String errMessage = e.getMessage();
            itemInfo = (item.isNode() ? "NODE " : "PROPERTY ") + item.getQPath().getAsString() + " " + item.getUUID() + (errMessage != null ? ". Cause: " + errMessage : "");
            if (errMessage != null) {
                String umsg = errMessage.toLowerCase().toUpperCase();
                if (umsg.indexOf(this.conn.JCR_FK_NODE_PARENT) >= 0) {
                    message = message + "Parent not found for " + itemInfo;
                    throw new InvalidItemStateException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_FK_NODE_ITEM) >= 0) {
                    message = message + "Item relation in JCR_ITEM table not found (not created). " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_FK_PROPERTY_NODE) >= 0) {
                    message = message + "Parent not found (not created) in JCR_NODE table. " + itemInfo;
                    throw new InvalidItemStateException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_FK_PROPERTY_ITEM) >= 0) {
                    message = message + "Item relation in JCR_ITEM table not found (not created). " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_FK_VALUE_PROPERTY) >= 0) {
                    message = message + "Property not found (not created) in JCR_PROPERTY table for values created. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
                if (umsg.indexOf(this.conn.JCR_PK_ITEM) >= 0) {
                    message = message + "An item with given ID already exists in JCR_ITEM table. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
            }
            RepositoryException ownException = null;
            try {
                block13: {
                    NodeData parent = (NodeData)this.conn.getItemData(item.getParentUUID());
                    if (parent == null) break block12;
                    try {
                        ItemData me = this.conn.getItemData(item.getUUID());
                        if (me != null) {
                            message = message + "Item already exists in storage: " + itemInfo;
                            ownException = new RepositoryException(message, (Throwable)e);
                            throw ownException;
                        }
                    }
                    catch (Exception ep) {
                        if (ownException == null) break block13;
                        throw ownException;
                    }
                }
                message = message + "Error of item add. " + itemInfo;
                ownException = new RepositoryException(message, (Throwable)e);
                throw ownException;
            }
            catch (Exception ep) {
                if (ownException == null) break block12;
                throw ownException;
            }
        }
        message = message + "Error of item add. " + itemInfo;
        throw new InvalidItemStateException(message, (Throwable)e);
    }

    protected String handleDeleteException(Exception e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String message = "[" + this.containerName + "] ";
        String errMessage = e.getMessage();
        String itemInfo = (item.isNode() ? "NODE " : "PROPERTY ") + item.getQPath().getAsString() + " " + item.getUUID() + (errMessage != null ? ". Cause: " + errMessage : "");
        if (errMessage != null) {
            String umsg = errMessage.toLowerCase().toUpperCase();
            if (umsg.indexOf(this.conn.JCR_FK_NODE_PARENT) >= 0) {
                message = message + "Can't delete parent till child exists " + itemInfo;
                throw new InvalidItemStateException(message, (Throwable)e);
            }
            if (umsg.indexOf(this.conn.JCR_FK_NODE_ITEM) >= 0) {
                message = message + "Can't delete item till related node exists in JCR_NODE table " + itemInfo;
                throw new RepositoryException(message, (Throwable)e);
            }
            if (umsg.indexOf(this.conn.JCR_FK_PROPERTY_NODE) >= 0) {
                message = message + "Can't delete node till child property(ies) exists in JCR_PROPERTY table " + itemInfo;
                throw new RepositoryException(message, (Throwable)e);
            }
            if (umsg.indexOf(this.conn.JCR_FK_PROPERTY_ITEM) >= 0) {
                message = message + "Can't delete item till related property exists in JCR_PROPERTY table " + itemInfo;
                throw new RepositoryException(message, (Throwable)e);
            }
            if (umsg.indexOf(this.conn.JCR_FK_VALUE_PROPERTY) >= 0) {
                message = message + "Can't delete property till related property values exists in JCR_VALUE table " + itemInfo;
                throw new RepositoryException(message, (Throwable)e);
            }
        }
        message = message + "Error of item delete " + itemInfo;
        throw new RepositoryException(message, (Throwable)e);
    }

    protected String handleUpdateException(Exception e, ItemData item) throws RepositoryException, InvalidItemStateException {
        String itemInfo;
        String message;
        block6: {
            message = "[" + this.containerName + "] ";
            String errMessage = e.getMessage();
            itemInfo = (item.isNode() ? "NODE " : "PROPERTY ") + item.getQPath().getAsString() + " " + item.getUUID() + (errMessage != null ? ". Cause: " + errMessage : "");
            if (errMessage != null) {
                if (errMessage.toLowerCase().toUpperCase().indexOf(this.conn.JCR_FK_VALUE_PROPERTY) >= 0) {
                    message = message + "Property not found (not created) in JCR_PROPERTY table for values updated. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
                if (errMessage.toLowerCase().toUpperCase().indexOf(this.conn.JCR_PK_ITEM) >= 0) {
                    message = message + "An item with given ID already exists in JCR_ITEM table. " + itemInfo;
                    throw new RepositoryException(message, (Throwable)e);
                }
            }
            RepositoryException ownException = null;
            try {
                ItemData me = this.conn.getItemData(item.getUUID());
                if (me != null) {
                    message = message + "Item exists but update error " + itemInfo;
                    ownException = new RepositoryException(message, (Throwable)e);
                    throw ownException;
                }
            }
            catch (Exception ep) {
                if (ownException == null) break block6;
                throw ownException;
            }
        }
        message = message + "Error of item update. " + itemInfo;
        throw new InvalidItemStateException(message, (Throwable)e);
    }
}

