/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.ValueStorageFilterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.swap.BinaryValueSwapStorage;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValuePluginFilter;
import org.exoplatform.services.jcr.storage.value.ValueStoragePlugin;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneStoragePluginProvider
extends ArrayList<ValueStoragePlugin>
implements ValueStoragePluginProvider {
    private static Log log = ExoLogger.getLogger((String)"jcr.ValueStoragePluginFactory");
    private BinaryValueSwapStorage binarySwap = null;

    public StandaloneStoragePluginProvider(WorkspaceEntry wsConfig) throws RepositoryException, RepositoryConfigurationException, NamingException, IOException {
        this(null, wsConfig);
    }

    public StandaloneStoragePluginProvider(BinaryValueSwapStorage binarySwap, WorkspaceEntry wsConfig) throws RepositoryException, RepositoryConfigurationException, NamingException, IOException {
        this.binarySwap = binarySwap;
        ArrayList storages = wsConfig.getContainer().getValueStorages();
        if (storages != null) {
            for (ValueStorageEntry storageEntry : storages) {
                Object o = null;
                try {
                    o = Class.forName(storageEntry.getType()).newInstance();
                }
                catch (Exception e) {
                    log.error((Object)"Value Storage Plugin instantiation FAILED. ", (Throwable)e);
                    continue;
                }
                if (!(o instanceof ValueStoragePlugin)) {
                    log.error((Object)("Not a ValueStoragePlugin object IGNORED: " + o));
                    continue;
                }
                ValueStoragePlugin plugin = o;
                ArrayList<ValuePluginFilter> filters = new ArrayList<ValuePluginFilter>();
                ArrayList filterEntries = storageEntry.getFilters();
                for (ValueStorageFilterEntry filterEntry : filterEntries) {
                    ValuePluginFilter filter = new ValuePluginFilter(PropertyType.valueFromName((String)filterEntry.getPropertyType()), null, null);
                    filters.add(filter);
                }
                Properties props = new Properties();
                List paramEntries = storageEntry.getParameters();
                for (SimpleParameterEntry paramEntry : paramEntries) {
                    props.setProperty(paramEntry.getName(), paramEntry.getValue());
                }
                plugin.init(props);
                plugin.setFilters(filters);
                this.add(plugin);
                log.info((Object)("Value Storage Plugin initialized " + plugin));
            }
        }
    }

    public ValueIOChannel getApplicableChannel(PropertyData property) throws IOException {
        for (ValueStoragePlugin plugin : this) {
            List filters = plugin.getFilters();
            for (ValuePluginFilter filter : filters) {
                if (!filter.match(property)) continue;
                return plugin.openIOChannel();
            }
        }
        return null;
    }

    public BinaryValueSwapStorage getBinaryValueSwap() {
        return this.binarySwap;
    }

    public Iterator<ValueStoragePlugin> plugins() {
        return this.iterator();
    }

    public void checkConsistency(WorkspaceStorageConnection dataConnection) {
        Iterator<ValueStoragePlugin> plugins = this.plugins();
        while (plugins.hasNext()) {
            ValueStoragePlugin plugin = plugins.next();
            plugin.checkConsistency(dataConnection);
        }
    }
}

