/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.FileValueIOUtil;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileIOChannel
implements ValueIOChannel {
    protected static Log log = ExoLogger.getLogger((String)"jcr.FileIOChannel");
    protected final File rootDir;
    protected final FileCleaner cleaner;

    public FileIOChannel(File rootDir, FileCleaner cleaner) {
        this.rootDir = rootDir;
        this.cleaner = cleaner;
    }

    public List<ValueData> read(String propertyId, int maxBufferSize) throws IOException {
        File[] valueFiles = this.rootDir.listFiles(new PropertyIDFilter(propertyId));
        ArrayList<ValueData> data = new ArrayList<ValueData>(valueFiles.length);
        for (int orderNum = 0; orderNum < valueFiles.length; ++orderNum) {
            ValueData vdata = FileValueIOUtil.readValue(valueFiles[orderNum], orderNum, maxBufferSize, false);
            data.add(vdata);
        }
        return data;
    }

    public void write(String propertyId, List<ValueData> values) throws IOException {
        for (ValueData value : values) {
            String fileName = propertyId + value.getOrderNumber();
            File file = new File(this.rootDir, fileName);
            FileValueIOUtil.writeValue(file, value);
        }
    }

    public boolean delete(String propertyId) throws IOException {
        File[] valueFiles = this.rootDir.listFiles(new PropertyIDFilter(propertyId));
        boolean result = true;
        for (File valueFile : valueFiles) {
            if (valueFile.delete()) continue;
            result = false;
            this.cleaner.addFile(valueFile);
        }
        return result;
    }

    public void close() {
    }

    private class PropertyIDFilter
    implements FileFilter {
        private String id;

        public PropertyIDFilter(String id) {
            this.id = id;
        }

        public boolean accept(File file) {
            return file.getName().startsWith(this.id);
        }
    }
}

