/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.jcr.ValueFormatException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;

public class DateFormatHelper {
    protected static Log log = ExoLogger.getLogger((String)"jcr.DateFormatHelper");
    protected static final String DATETZ_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final String CALENDAR_FIELDS_DELIMITER = ";";
    protected static final String CALENDAR_FIELDS_SEPARATOR = "--";

    public Calendar deserialize(String serString) throws ValueFormatException {
        String[] parts = serString.split(CALENDAR_FIELDS_SEPARATOR);
        if (parts.length == 2) {
            int start;
            int sign;
            if (parts[0].startsWith("-")) {
                sign = 45;
                start = 1;
            } else if (parts[0].startsWith("+")) {
                sign = 43;
                start = 1;
            } else {
                sign = 43;
                start = 0;
            }
            Date isoDate = null;
            try {
                isoDate = new SimpleDateFormat(DATETZ_FORMAT).parse(parts[0].substring(start));
            }
            catch (ParseException e) {
                throw new ValueFormatException("Can't parse serialized calendar from '" + parts[0].substring(start) + "' text, source '" + parts[0] + "', string '" + serString + "'", (Throwable)e);
            }
            catch (NumberFormatException e) {
                throw new ValueFormatException("Can't parse serialized calendar from '" + parts[0].substring(start) + "' text, source '" + parts[0] + "', string '" + serString + "'", (Throwable)e);
            }
            Calendar isoCalendar = Calendar.getInstance();
            isoCalendar.setTime(isoDate);
            String[] calendarFields = parts[1].split(CALENDAR_FIELDS_DELIMITER);
            if (calendarFields.length == 4) {
                try {
                    isoCalendar.setLenient(Boolean.parseBoolean(calendarFields[0]));
                    isoCalendar.setFirstDayOfWeek(Integer.parseInt(calendarFields[1]));
                    isoCalendar.setMinimalDaysInFirstWeek(Integer.parseInt(calendarFields[2]));
                    isoCalendar.setTimeZone(TimeZone.getTimeZone(calendarFields[3]));
                }
                catch (Exception e) {
                    log.warn((Object)("Can't parse serialized fields for the calendar '" + parts[1] + "' but calendar has '" + isoDate.toString() + "'"), (Throwable)e);
                }
            } else {
                log.warn((Object)("Fields of the calendar is not serialized properly '" + parts[1] + "' but calendar has '" + isoDate.toString() + "'"));
            }
            if (sign == 45 || isoCalendar.get(1) == 0) {
                isoCalendar.set(1, isoCalendar.get(1) + 1);
                isoCalendar.set(0, 0);
            }
            return isoCalendar;
        }
        throw new ValueFormatException("Can't deserialize calendar string '" + serString + "'");
    }

    public byte[] serialize(Calendar date) {
        String calendarString = CALENDAR_FIELDS_SEPARATOR + date.isLenient() + CALENDAR_FIELDS_DELIMITER + date.getFirstDayOfWeek() + CALENDAR_FIELDS_DELIMITER + date.getMinimalDaysInFirstWeek() + CALENDAR_FIELDS_DELIMITER + date.getTimeZone().getID();
        SimpleDateFormat formater = new SimpleDateFormat(DATETZ_FORMAT);
        formater.setTimeZone(date.getTimeZone());
        return (formater.format(date.getTime()) + calendarString).getBytes();
    }
}

