/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.value.StringValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.ItemDataReader;
import org.exoplatform.services.jcr.util.io.BLOBUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyDataReader
extends ItemDataReader {
    private HashMap<InternalQName, PropertyInfo> propeties = new HashMap();

    public PropertyDataReader(NodeData parent, DataManager dataManager, ValueFactoryImpl valueFactory) {
        super(parent, dataManager, valueFactory);
    }

    public PropertyDataReader forProperty(InternalQName name, int type) {
        this.propeties.put(name, new PropertyInfo(name, type));
        return this;
    }

    public List<ValueData> getPropertyValueDatas(InternalQName name) throws ValueFormatException, PathNotFoundException {
        return this.propeties.get(name).getValueDatas();
    }

    public List<Value> getPropertyValues(InternalQName name) throws ValueFormatException, PathNotFoundException, RepositoryException {
        return this.propeties.get(name).getValues();
    }

    public Value getPropertyValue(InternalQName name) throws ValueFormatException, PathNotFoundException, RepositoryException {
        return this.propeties.get(name).getValue();
    }

    public ValueData getPropertyValueData(InternalQName name) throws ValueFormatException, PathNotFoundException {
        return this.propeties.get(name).getValueData();
    }

    public void read() throws RepositoryException {
        List ndProps = this.dataManager.getChildPropertiesData(this.parent);
        for (PropertyData prop : ndProps) {
            PropertyInfo propInfo = this.propeties.get(prop.getQPath().getName());
            if (propInfo == null) continue;
            List valueDataList = prop.getValues();
            if (prop.isMultiValued()) {
                propInfo.setValueDatas(valueDataList);
                continue;
            }
            if (valueDataList.size() <= 0) continue;
            propInfo.setValueData((ValueData)valueDataList.get(0));
        }
    }

    private Value makeValue(ValueData valueData, int type) throws RepositoryException {
        if (this.valueFactory != null) {
            TransientValueData tvd = ((AbstractValueData)valueData).createTransientCopy();
            return this.valueFactory.loadValue(tvd, type);
        }
        try {
            return new StringValue(new String(BLOBUtil.readValue((ValueData)valueData), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            try {
                return new StringValue(new String(valueData.getAsByteArray()));
            }
            catch (IOException e1) {
                throw new RepositoryException("Can't make value from value data: " + e1.getMessage(), (Throwable)e1);
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Can't make value from value data: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyInfo {
        private InternalQName propertyName = null;
        private boolean multiValued = false;
        private List<ValueData> mValueData = null;
        private List<Value> mValue = null;
        private ValueData valueData = null;
        private Value value = null;
        private int type = 1;

        PropertyInfo(InternalQName propertyName, int type) {
            this.propertyName = propertyName;
            this.type = type;
        }

        public InternalQName getPropertyName() {
            return this.propertyName;
        }

        public boolean isMultiValued() {
            return this.multiValued;
        }

        public void setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
        }

        public List<Value> getValues() throws ValueFormatException, PathNotFoundException, RepositoryException {
            if (this.mValue == null) {
                List<ValueData> vds = this.getValueDatas();
                ArrayList<Value> vs = new ArrayList<Value>();
                for (ValueData vd : vds) {
                    vs.add(PropertyDataReader.this.makeValue(vd, this.getType()));
                }
                this.mValue = vs;
            }
            return this.mValue;
        }

        public List<ValueData> getValueDatas() throws ValueFormatException, PathNotFoundException {
            if (this.multiValued) {
                if (this.mValueData != null) {
                    return this.mValueData;
                }
            } else if (this.valueData != null) {
                throw new ValueFormatException("Property " + PropertyDataReader.this.parent.getQPath().getAsString() + this.propertyName.getAsString() + " is multi-valued");
            }
            throw new PathNotFoundException("Property " + PropertyDataReader.this.parent.getQPath().getAsString() + this.propertyName.getAsString() + " not found (multi-valued)");
        }

        public void setValueDatas(List<ValueData> mValue) {
            this.mValueData = mValue;
            this.multiValued = true;
        }

        public Value getValue() throws ValueFormatException, PathNotFoundException, RepositoryException {
            if (this.value == null) {
                this.value = PropertyDataReader.this.makeValue(this.getValueData(), this.getType());
            }
            return this.value;
        }

        public ValueData getValueData() throws ValueFormatException, PathNotFoundException {
            if (!this.multiValued) {
                if (this.valueData != null) {
                    return this.valueData;
                }
            } else if (this.mValueData != null) {
                throw new ValueFormatException("Property " + PropertyDataReader.this.parent.getQPath().getAsString() + this.propertyName.getAsString() + " is single-valued");
            }
            throw new PathNotFoundException("Property " + PropertyDataReader.this.parent.getQPath().getAsString() + this.propertyName.getAsString() + " not found (single-valued)");
        }

        public void setValueData(ValueData value) {
            this.valueData = value;
            this.multiValued = false;
        }

        public int getType() {
            return this.type;
        }
    }
}

