/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;

public class StringConverter {
    private static String ILLEGAL_DNCHAR = "StringConverter: empty string for denormalization to char";
    private static Log log = ExoLogger.getLogger((String)"jcr.StringConverter");

    public static String normalizeString(String s, boolean canonical) {
        StringBuffer strBuf = new StringBuffer();
        int len = s != null ? s.length() : 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            String spart = s.substring(i);
            if (spart.startsWith("_") && !spart.startsWith("_x")) {
                strBuf.append(c);
                continue;
            }
            strBuf.append(StringConverter.normalizeChar(c, canonical));
        }
        return new String(strBuf);
    }

    public static String denormalizeString(String s) {
        StringBuffer strBuf = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            try {
                DNChar dnc = StringConverter.denormalize(s.substring(i));
                strBuf.append(dnc.getDnChar());
                i += dnc.getDnLength();
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().equals(ILLEGAL_DNCHAR)) {
                    throw e;
                }
                char c = s.charAt(i);
                strBuf.append(c);
                ++i;
            }
        }
        return new String(strBuf);
    }

    public static String normalizeChar(char c, boolean canonical) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\r': {
                if (canonical) {
                    return "_x000D_";
                }
            }
            case '\n': {
                if (canonical) {
                    return "_x000A_";
                }
            }
            case '\t': {
                if (canonical) {
                    return "_x0009_";
                }
            }
            case ' ': {
                if (canonical) {
                    return "_x0020_";
                }
            }
            case '_': {
                if (!canonical) break;
                return "_x005f_";
            }
        }
        return "" + c;
    }

    public static char denormalizeChar(String string) {
        return StringConverter.denormalize(string).getDnChar();
    }

    private static DNChar denormalize(String string) {
        if (string.equals("&lt;")) {
            return new DNChar('<', 4);
        }
        if (string.startsWith("&gt;")) {
            return new DNChar('>', 4);
        }
        if (string.startsWith("&quot;")) {
            return new DNChar('\"', 6);
        }
        if (string.startsWith("_x000D_")) {
            return new DNChar('\r', 7);
        }
        if (string.startsWith("_x000A_")) {
            return new DNChar('\n', 7);
        }
        if (string.startsWith("_x0020_")) {
            return new DNChar(' ', 7);
        }
        if (string.startsWith("_x005f_")) {
            return new DNChar('_', 7);
        }
        throw new IllegalArgumentException(ILLEGAL_DNCHAR);
    }

    private static class DNChar {
        private char dnChar;
        private int dnLength;

        public DNChar(char dnChar, int dnLength) {
            this.dnChar = dnChar;
            this.dnLength = dnLength;
        }

        public char getDnChar() {
            return this.dnChar;
        }

        public int getDnLength() {
            return this.dnLength;
        }
    }
}

