/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.proccess.WorkerThread;
import org.exoplatform.services.log.ExoLogger;

public class FileCleaner
extends WorkerThread {
    private static final long DEFAULT_TIMEOUT = 10000L;
    protected static Log log = ExoLogger.getLogger((String)"jcr.FileCleaner");
    List<File> files = new ArrayList<File>();

    public FileCleaner() {
        this(10000L);
    }

    public FileCleaner(long timeout) {
        super(timeout);
        this.setName("FileCleaner " + this.getId());
        this.setPriority(1);
        this.start();
        this.registerShutdownHook();
        log.info((Object)("FileCleaner instantiated name= " + this.getName() + " timeout= " + timeout));
    }

    public synchronized void addFile(File file) {
        if (file.exists()) {
            this.files.add(file);
        }
    }

    public void halt() {
        try {
            this.callPeriodically();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.files.size() > 0) {
            log.warn((Object)("There are uncleared files: " + this.files.size()));
        }
        super.halt();
    }

    protected void callPeriodically() throws Exception {
        if (this.files != null && this.files.size() > 0) {
            List<File> oldFiles = this.files;
            this.files = new ArrayList<File>();
            for (File file : oldFiles) {
                if (!file.exists()) continue;
                if (!file.delete()) {
                    log.warn((Object)("Could not delete file. Will try next time: " + file.getAbsolutePath()));
                    this.files.add(new File(file.getAbsolutePath()));
                    continue;
                }
                log.debug((Object)("File deleted : " + file.getAbsolutePath()));
            }
        }
    }

    private void registerShutdownHook() {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    List<File> oldFiles = FileCleaner.this.files;
                    FileCleaner.this.files = null;
                    List<File> list = oldFiles;
                    synchronized (list) {
                        for (File file : oldFiles) {
                            file.delete();
                        }
                    }
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

