/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FileStreamPersistedValueData;

public class FileValueIOUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValueData readValue(File file, int orderNum, int maxBufferSize, boolean temp) throws IOException {
        FileInputStream is = new FileInputStream(file);
        FileChannel channel = is.getChannel();
        try {
            int size = (int)channel.size();
            if (size > maxBufferSize) {
                FileStreamPersistedValueData fileStreamPersistedValueData = new FileStreamPersistedValueData(file, orderNum, temp);
                return fileStreamPersistedValueData;
            }
            ByteBuffer buf = ByteBuffer.allocate(size);
            int numRead = channel.read(buf);
            byte[] arr = new byte[numRead];
            buf.rewind();
            buf.get(arr);
            ByteArrayPersistedValueData byteArrayPersistedValueData = new ByteArrayPersistedValueData(arr, orderNum);
            return byteArrayPersistedValueData;
        }
        finally {
            channel.close();
            is.close();
        }
    }

    public static void writeValue(File file, ValueData value) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        if (value.isByteArray()) {
            byte[] buff = value.getAsByteArray();
            out.write(buff);
        } else {
            int len;
            byte[] buffer = new byte[8192];
            InputStream in = value.getAsStream();
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        out.close();
    }
}

