/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ContentHandlerWrapper
implements ContentHandler {
    protected Log log = LogFactory.getLog(this.getClass());
    private ContentHandler contentHandler = null;
    private Map currentNamespaceScope = new Hashtable();
    private Collection newNamespaces = new ArrayList();

    public ContentHandlerWrapper(ContentHandler contentHandler) {
        this.log.debug((Object)("Created, specified contentHandler is null? - " + (contentHandler == null)));
        this.contentHandler = contentHandler;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.log.trace((Object)("characters char[" + new String(ch, 0, length) + "] start[" + start + "] length[" + length + "]"));
        if (this.contentHandler != null) {
            this.contentHandler.characters(ch, start, length);
        }
    }

    public void endDocument() throws SAXException {
        this.log.trace((Object)"endDocument");
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.log.trace((Object)("endElement namespaceURI[" + namespaceURI + "] localName[" + localName + "] qName[" + qName + "]"));
        if (this.contentHandler != null) {
            this.contentHandler.endElement(namespaceURI, localName, qName);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.log.trace((Object)("endPrefixMapping prefix[" + prefix + "]"));
        this.currentNamespaceScope.remove(prefix);
        this.newNamespaces.remove(prefix);
        if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.log.trace((Object)("ignorableWhitespace char[" + new String(ch, start, length) + "] start[" + start + "] length[" + length + "]"));
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.log.trace((Object)("processingInstruction target[" + target + "] + data[" + data + "]"));
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.log.trace((Object)"setDocumentLocator");
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        this.log.trace((Object)("skippedEntity name[" + name + "]"));
        if (this.contentHandler != null) {
            this.contentHandler.skippedEntity(name);
        }
    }

    public void startDocument() throws SAXException {
        this.log.trace((Object)"startDocument");
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.log.trace((Object)("startElement namespaceURI[" + namespaceURI + "] localName[" + localName + "] qName[" + qName + "]atts count [" + atts.getLength() + "]"));
        if (this.contentHandler != null) {
            this.contentHandler.startElement(namespaceURI, localName, qName, atts);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.log.trace((Object)("startPrefixMapping prefix[" + prefix + "] uri[" + uri + "]"));
        if (!this.currentNamespaceScope.containsKey(prefix) || !this.currentNamespaceScope.get(prefix).equals(uri)) {
            this.currentNamespaceScope.put(prefix, uri);
            this.newNamespaces.add(prefix);
        }
        if (this.contentHandler != null) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    private Attributes addNamespaceDefinitionsToAttr(Attributes atts) {
        Attributes newAtts = atts;
        if (this.newNamespaces.size() > 0 && atts != null) {
            AttributesImpl attsImpl = new AttributesImpl(atts);
            for (String prefix : this.newNamespaces) {
                if (attsImpl.getIndex("xmlns:".concat(prefix)) != -1) continue;
                attsImpl.addAttribute("", prefix, "xmlns:".concat(prefix), "CDATA", (String)this.currentNamespaceScope.get(prefix));
            }
            this.newNamespaces.clear();
            newAtts = attsImpl;
        }
        return newAtts;
    }
}

