/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.util.ISO9075;
import org.exoplatform.services.jcr.impl.xml.ExportXmlVisitor;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class DocExportXmlVisitor
extends ExportXmlVisitor {
    private StringBuffer buffer;
    protected String encoding;
    private AttributesImpl currentAttr = null;

    public DocExportXmlVisitor(ContentHandler handler, SessionImpl session, ItemDataConsumer dataManager, boolean skipBinary, boolean noRecurse) {
        super(handler, session, dataManager, skipBinary, noRecurse);
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        InternalQName name = property.getQPath().getName();
        this.currentAttr.addAttribute(name.getNamespace(), name.getName(), name.getAsString(), "CDATA", this.locationFactory.createJCRName(property.getQPath().getName()).getAsString());
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        InternalQName internalNodeName = ISO9075.encode(node.getQPath().getName());
        String nodeName = this.session.getLocationFactory().createJCRName(internalNodeName).getAsString();
        if (nodeName.length() <= 0) {
            nodeName = "jcr:root";
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("[http://www.jcp.org/jcr/1.0]", "name", "sv:name", "CDATA", this.locationFactory.createJCRName(node.getQPath().getName()).getAsString());
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
    }
}

