/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.commons.codec.binary.Base64;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.value.BinaryValue;
import org.exoplatform.services.jcr.impl.dataflow.NodeDataOrderComparator;
import org.exoplatform.services.jcr.impl.dataflow.PropertyDataOrderComparator;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.StringConverter;
import org.exoplatform.services.jcr.util.io.BLOBUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class ExportXmlVisitor
extends ItemDataTraversingVisitor {
    public static final int BINARY_PROCESS = 0;
    public static final int BINARY_SKIP = 1;
    public static final int BINARY_EMPTY = 2;
    private int binaryConduct = 0;
    protected boolean noRecurse;
    protected final ContentHandler contentHandler;
    protected final SessionImpl session;
    protected LocationFactory locationFactory;

    public ExportXmlVisitor(ContentHandler handler, SessionImpl session, ItemDataConsumer dataManager, boolean skipBinary, boolean noRecurse) {
        super(dataManager, noRecurse ? 1 : -1);
        this.session = session;
        if (!(session instanceof SessionImpl)) {
            throw new IllegalArgumentException("session not an instanceof SessionImpl");
        }
        this.locationFactory = session.getLocationFactory();
        this.contentHandler = handler;
        this.setBinaryConduct(skipBinary ? 1 : 0);
        this.setNoRecurse(noRecurse);
    }

    public int getBinaryConduct() {
        return this.binaryConduct;
    }

    public void setBinaryConduct(int binaryConduct) {
        if (binaryConduct != 0 && binaryConduct != 1 && binaryConduct != 2) {
            throw new IllegalArgumentException("binaryConduct must be one of BINARY_PROCESS,BINARY_SKIP, BINARY_EMPTY");
        }
        this.binaryConduct = binaryConduct;
    }

    public boolean isNoRecurse() {
        return this.noRecurse;
    }

    public void setNoRecurse(boolean noRecurse) {
        this.noRecurse = noRecurse;
    }

    public void export(NodeData node) throws RepositoryException, SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
            this.startPrefixMapping();
            node.accept((ItemDataVisitor)this);
            this.endPrefixMapping();
            this.contentHandler.endDocument();
        }
    }

    protected char[] serializeValueData(ValueData data, int type) throws Exception {
        char[] charValue = "".toCharArray();
        switch (type) {
            case 2: {
                if (this.getBinaryConduct() == 1) break;
                if (this.getBinaryConduct() == 2) {
                    try {
                        charValue = new BinaryValue("").getString().toCharArray();
                        break;
                    }
                    catch (IOException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                }
                charValue = new String(Base64.encodeBase64((byte[])BLOBUtil.readValue((ValueData)data))).toCharArray();
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                charValue = this.session.getValueFactory().loadValue((TransientValueData)data, type).getString().toCharArray();
                break;
            }
            default: {
                charValue = new String(data.getAsByteArray()).toCharArray();
            }
        }
        return charValue;
    }

    private String[] getStrPropValues(PropertyImpl prop, boolean skipBinary) throws ValueFormatException, RepositoryException {
        String[] values = new String[prop.getValueArray().length];
        if (values.length == 0) {
            return null;
        }
        if (prop.getType() == 2) {
            if (skipBinary) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = "";
                }
            } else {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        String b64s;
                        TransientValueData data = ((BinaryValue)prop.getValueArray()[i]).getInternalData();
                        values[i] = b64s = new String(Base64.encodeBase64((byte[])BLOBUtil.readValue((ValueData)data)));
                        continue;
                    }
                    catch (IOException e) {
                        throw new RepositoryException("Can't export value data to string: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            for (int i = 0; i < values.length; ++i) {
                Value val = prop.getValueArray()[i];
                try {
                    if (val == null) continue;
                    values[i] = StringConverter.normalizeString(val.getString(), true);
                    continue;
                }
                catch (ValueFormatException e) {
                    if (e.getMessage().equals("empty value")) continue;
                    throw e;
                }
            }
        }
        return values;
    }

    protected void startPrefixMapping() throws RepositoryException, SAXException {
        String[] prefixes;
        for (String prefix : prefixes = this.session.getNamespacePrefixes()) {
            if (prefix.equals("xml")) continue;
            this.contentHandler.startPrefixMapping(prefix, this.session.getNamespaceURI(prefix));
        }
    }

    protected void endPrefixMapping() throws RepositoryException, SAXException {
        String[] prefixes;
        for (String prefix : prefixes = this.session.getNamespacePrefixes()) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    public void visit(NodeData node) throws RepositoryException {
        try {
            this.entering(node, this.currentLevel);
            if (this.maxLevel == -1 || this.currentLevel < this.maxLevel) {
                ++this.currentLevel;
                List properies = this.dataManager.getChildPropertiesData(node);
                Collections.sort(properies, new PropertyDataOrderComparator());
                for (PropertyData data : properies) {
                    data.accept((ItemDataVisitor)this);
                }
                if (!this.isNoRecurse() && this.currentLevel > 0) {
                    List nodes = this.dataManager.getChildNodesData(node);
                    Collections.sort(nodes, new NodeDataOrderComparator());
                    for (NodeData data : nodes) {
                        data.accept((ItemDataVisitor)this);
                    }
                }
                --this.currentLevel;
            }
            this.leaving(node, this.currentLevel);
        }
        catch (RepositoryException re) {
            this.currentLevel = 0;
            throw re;
        }
    }

    private void writeAttribute(String qname, String value) {
    }

    private void writeNamespaces() throws RepositoryException {
        String[] keys = this.session.getAllNamespacePrefixes();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].length() <= 0) continue;
            this.writeAttribute("xmlns:" + keys[i], this.session.getNamespaceURIByPrefix(keys[i]));
        }
    }
}

