/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImporterBase
implements ContentHandler {
    protected int uuidBehavior = -1;
    protected SessionImpl session;
    protected NodeTypeManagerImpl ntManager;
    protected List<ItemState> itemStatesList;
    protected LocationFactory locationFactory;

    ImporterBase(NodeImpl parent, int uuidBehavior) {
        this.session = parent.getSession();
        this.ntManager = (NodeTypeManagerImpl)((RepositoryImpl)this.session.getRepository()).getNodeTypeManager();
        this.locationFactory = this.session.getLocationFactory();
        this.uuidBehavior = uuidBehavior;
        this.itemStatesList = new ArrayList<ItemState>();
    }

    protected PropertyDefinition getPropertyDefinition(String propertyName, List<ExtendedNodeType> nodeTypes) {
        PropertyDefinition pdResidual = null;
        for (ExtendedNodeType nt : nodeTypes) {
            PropertyDefinitions pds = nt.getPropertyDefinitions(propertyName);
            PropertyDefinition pd = pds.getAnyDefinition();
            if (pd == null) continue;
            if (((PropertyDefinitionImpl)pd).isResidualSet()) {
                pdResidual = pd;
                continue;
            }
            return pd;
        }
        return pdResidual;
    }

    protected boolean isReferenceable(List<ExtendedNodeType> nodeTypes) {
        for (ExtendedNodeType nt : nodeTypes) {
            if (!nt.isNodeType(Constants.MIX_REFERENCEABLE)) continue;
            return true;
        }
        return false;
    }

    public List<ItemState> getItemStatesList() {
        return this.itemStatesList;
    }

    public void setItemStatesList(List<ItemState> itemStatesList) {
        this.itemStatesList = itemStatesList;
    }

    protected List<ItemState> getItemStatesList(InternalQPath path, int state) {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        for (ItemState itemState : this.itemStatesList) {
            if (!itemState.getData().getQPath().equals((Object)path) || state != 0 && state != itemState.getState()) continue;
            states.add(itemState);
        }
        return states;
    }

    protected ItemData getLocalItemData(InternalQPath path) {
        ItemData item = null;
        List<ItemState> states = this.getItemStatesList(path, 0);
        ItemState state = states.get(states.size() - 1);
        if (!state.isDeleted()) {
            item = state.getData();
        }
        return item;
    }

    public int getNodeIndex(InternalQPath path) throws PathNotFoundException, IllegalPathException, RepositoryException {
        int newIndex = 1;
        NodeImpl parentNode = (NodeImpl)this.session.getTransientNodesManager().getItem(path.makeParentPath(), true);
        NodeData parentNodeData = null;
        if (parentNode == null) {
            parentNodeData = (NodeData)this.getLocalItemData(path.makeParentPath());
            if (parentNodeData == null) {
                throw new RepositoryException("invalid state getNodeIndex");
            }
        } else {
            parentNodeData = (NodeData)parentNode.getData();
        }
        NodeDefinitionImpl nodedef = this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(path.getName(), parentNodeData.getPrimaryTypeName(), parentNodeData.getMixinTypeNames());
        NodeImpl sameNameNode = null;
        try {
            sameNameNode = (NodeImpl)this.session.getTransientNodesManager().getItem(path, true);
        }
        catch (PathNotFoundException e) {
            return newIndex;
        }
        List<ItemState> transientAddChilds = this.getItemStatesList(path, 1);
        List<ItemState> transientDeletedChilds = this.getItemStatesList(path, 3);
        if (!(nodedef.allowsSameNameSiblings() || sameNameNode == null && transientAddChilds.size() <= 0)) {
            if (sameNameNode != null && transientDeletedChilds.size() < 1) {
                throw new ItemExistsException("The node  already exists in " + path.getAsString() + " and same name sibling is not allowed ");
            }
            if (transientAddChilds.size() > 0) {
                throw new ItemExistsException("The node  already exists in add state " + path.getAsString() + "  and same name sibling is not allowed ");
            }
        }
        newIndex += transientAddChilds.size();
        List<NodeData> existedChilds = this.session.getTransientNodesManager().getChildNodesData(parentNodeData);
        for (NodeData child : existedChilds) {
            if (transientDeletedChilds.size() != 0 || !child.getQPath().getName().equals((Object)path.getName())) continue;
            ++newIndex;
        }
        return newIndex;
    }
}

