/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.util.NodeTypeRecognizer;
import org.exoplatform.services.jcr.impl.xml.DocNodeImporter;
import org.exoplatform.services.jcr.impl.xml.ImporterBase;
import org.exoplatform.services.jcr.impl.xml.SysNodeImporter;
import org.exoplatform.services.log.ExoLogger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class NodeImporter
extends DefaultHandler {
    protected static Log log = ExoLogger.getLogger((String)"jcr.NodeImporter");
    public static final int SAVETYPE_NONE = 1;
    public static final int SAVETYPE_UPDATE = 2;
    public static final int SAVETYPE_SAVE = 4;
    private int saveType;
    private ContentHandler wrappedHandler;
    protected NodeImpl parent;
    protected int uuidBehavior = -1;
    private NamespaceRegistry nsReg;
    private SessionImpl session;
    private PrintStream userErrorStream = null;
    private boolean saveOnEnd = false;

    public NodeImporter(NodeImpl parent) throws RepositoryException {
        this.parent = parent;
        this.nsReg = parent.getSession().getWorkspace().getNamespaceRegistry();
        this.session = parent.getSession();
        this.setSaveType(1);
    }

    public void parse(InputStream stream) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        XMLReader reader;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            reader = factory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new SAXException(e.getMessage());
        }
        reader.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        reader.setContentHandler(this);
        reader.setErrorHandler(this);
        reader.parse(new InputSource(stream));
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.wrappedHandler == null) {
            throw new SAXException("Handler is not set.");
        }
        this.wrappedHandler.characters(ch, start, length);
    }

    public void endDocument() throws SAXException {
        if (this.wrappedHandler == null) {
            throw new SAXException("Handler is not set.");
        }
        this.wrappedHandler.endDocument();
        try {
            List<ItemState> itemStates = null;
            if (!(this.wrappedHandler instanceof ImporterBase)) {
                throw new RepositoryException("wrong handler");
            }
            itemStates = ((ImporterBase)this.wrappedHandler).getItemStatesList();
            switch (this.getSaveType()) {
                case 2: {
                    for (ItemState itemState : itemStates) {
                        switch (itemState.getState()) {
                            case 1: {
                                this.session.getTransientNodesManager().update(itemState, true);
                                break;
                            }
                            case 3: {
                                this.session.getTransientNodesManager().delete(itemState.getData());
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    ItemDataChangesLog changesLog = new ItemDataChangesLog(itemStates, this.session.getId());
                    this.session.getTransientNodesManager().getTransactManager().save(changesLog);
                    break;
                }
            }
        }
        catch (RepositoryException e) {
            throw new SAXException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.wrappedHandler == null) {
            throw new SAXException("Handler is not set.");
        }
        this.wrappedHandler.endElement(namespaceURI, localName, qName);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.wrappedHandler == null) {
            try {
                this.recognizeDocumentType(namespaceURI, qName);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
        this.wrappedHandler.startElement(namespaceURI, localName, qName, atts);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            this.nsReg.getPrefix(uri);
        }
        catch (NamespaceException e) {
            try {
                this.nsReg.registerNamespace(prefix, uri);
            }
            catch (NamespaceException e1) {
                throw new RuntimeException(e1);
            }
            catch (RepositoryException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected final void recognizeDocumentType(String namespaceURI, String qName) throws RepositoryException {
        this.wrappedHandler = NodeTypeRecognizer.recognize(namespaceURI, qName) == 1 ? new SysNodeImporter(this.parent, this.uuidBehavior) : new DocNodeImporter(this.parent, this.uuidBehavior);
    }

    protected final void recognizeDocumentType(InputStream is) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        if (NodeTypeRecognizer.recognize(is) == 1) {
            this.wrappedHandler = new SysNodeImporter(this.parent, this.uuidBehavior);
        } else {
            DocNodeImporter importer = new DocNodeImporter(this.parent, this.uuidBehavior);
            importer.setSaveOnEnd(this.isSaveOnEnd());
            this.wrappedHandler = importer;
        }
    }

    public void setUuidBehavior(int uuidBehavior) {
        this.uuidBehavior = uuidBehavior;
    }

    public int getUuidBehavior() {
        return this.uuidBehavior;
    }

    public void error(SAXParseException err) throws SAXException {
        this.errorErrorLog(err.getLocalizedMessage(), err);
    }

    public void fatalError(SAXParseException err) throws SAXException {
        this.fatalErrorLog(err.getLocalizedMessage(), err);
    }

    public void warning(SAXParseException err) throws SAXException {
        this.warnErrorLog(err.getLocalizedMessage(), err);
    }

    private void warnErrorLog(String message, Throwable exception) {
        log.warn((Object)message);
    }

    private void errorErrorLog(String message, Throwable exception) {
        log.error((Object)message);
    }

    private void fatalErrorLog(String message, Throwable exception) {
        log.fatal((Object)message);
    }

    @Deprecated
    private void toErrorLog(String message, Throwable exception) {
        String err = "ErrorHandler (exo-jcr NodeImporter) " + (message != null && message.length() > 0 ? message + ": " : "") + "Exception: " + exception;
        PrintStream errStream = this.userErrorStream != null ? this.userErrorStream : System.err;
        errStream.println(err);
        exception.printStackTrace(errStream);
    }

    public void setUserErrorStream(PrintStream printStream) {
        this.userErrorStream = printStream;
    }

    public PrintStream getUserErrorStream() {
        return this.userErrorStream;
    }

    public boolean isSaveOnEnd() {
        return this.saveOnEnd;
    }

    @Deprecated
    public void setSaveOnEnd(boolean saveOnEnd) {
        this.saveOnEnd = saveOnEnd;
    }

    public int getSaveType() {
        return this.saveType;
    }

    public void setSaveType(int saveType) {
        this.saveType = saveType;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return null;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }
}

