/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.xml.ExportXmlVisitor;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SysExportXmlVisior
extends ExportXmlVisitor {
    private final String SV_NAMESPACE_URI;

    public SysExportXmlVisior(ContentHandler handler, SessionImpl session, ItemDataConsumer dataManager, boolean skipBinary, boolean noRecurse) throws NamespaceException, RepositoryException {
        super(handler, session, dataManager, skipBinary, noRecurse);
        if (handler == null) {
            throw new IllegalArgumentException("ContentHandler can't be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("session can't be null");
        }
        this.SV_NAMESPACE_URI = session.getNamespaceURI("sv");
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(this.SV_NAMESPACE_URI, "name", "sv:name", "CDATA", this.locationFactory.createJCRName(property.getQPath().getName()).getAsString());
            atts.addAttribute(this.SV_NAMESPACE_URI, "type", "sv:type", "CDATA", ExtendedPropertyType.nameFromValue((int)property.getType()));
            this.contentHandler.startElement(this.SV_NAMESPACE_URI, "property", "sv:property", atts);
            List values = property.getValues();
            for (ValueData valueData : values) {
                this.contentHandler.startElement(this.SV_NAMESPACE_URI, "value", "sv:value", new AttributesImpl());
                char[] charValue = this.serializeValueData(valueData, property.getType());
                this.contentHandler.characters(charValue, 0, charValue.length);
                this.contentHandler.endElement(this.SV_NAMESPACE_URI, "value", "sv:value");
            }
        }
        catch (Exception e) {
            throw new RepositoryException("Can't export value to string: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        try {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(this.SV_NAMESPACE_URI, "name", "sv:name", "CDATA", this.locationFactory.createJCRName(node.getQPath().getName()).getAsString());
            this.contentHandler.startElement(this.SV_NAMESPACE_URI, "node", "sv:node", atts);
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
        try {
            this.contentHandler.endElement(this.SV_NAMESPACE_URI, "property", "sv:property");
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        try {
            this.contentHandler.endElement(this.SV_NAMESPACE_URI, "node", "sv:node");
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }
}

