/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.itemfilters.NamePatternFilter;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.jcr.impl.xml.ImporterBase;
import org.exoplatform.services.jcr.util.UUIDGenerator;
import org.exoplatform.services.jcr.util.io.BLOBUtil;
import org.exoplatform.services.log.ExoLogger;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class SysNodeImporter
extends ImporterBase {
    protected Log log = ExoLogger.getLogger((String)"jcr.SysNodeImporter");
    private Stack<NodeInfo> tree;
    private String curPropName;
    private String curPropType;
    private List<StringBuffer> curPropValues;
    private List<NodeInfo> nodeInfos;
    private NodeData parent;
    private InternalQName primaryTypeName;
    private List<ParsedPropertyInfo> propsParsed;
    private List<ExtendedNodeType> nodeTypes;
    private InternalQName[] mixinTypeNames;

    SysNodeImporter(NodeImpl parent, int uuidBehavior) throws RepositoryException {
        super(parent, uuidBehavior);
        this.parent = (NodeData)parent.getData();
        this.tree = new Stack();
        this.nodeInfos = new ArrayList<NodeInfo>();
        this.curPropValues = new ArrayList<StringBuffer>();
    }

    private void buildNode() throws RepositoryException {
        TransientNodeData node = null;
        LinkedHashMap<String, TransientNodeData> parents = new LinkedHashMap<String, TransientNodeData>();
        for (int i = 0; i < this.nodeInfos.size(); ++i) {
            NodeInfo info = this.nodeInfos.get(i);
            this.mixinTypeNames = null;
            this.nodeTypes = new ArrayList<ExtendedNodeType>();
            this.propsParsed = new ArrayList<ParsedPropertyInfo>();
            this.primaryTypeName = null;
            NodeData parentNode = null;
            String relPathStr = info.getRelPath();
            String uuid = null;
            uuid = this.traverseNodeInfo(relPathStr, info);
            boolean hasMixReferenceable = this.isReferenceable(this.nodeTypes);
            if (hasMixReferenceable && (uuid = this.validateUuidCollision(uuid)) == null) {
                throw new RepositoryException("Ipossible state");
            }
            int lastPathElem = relPathStr.lastIndexOf("/");
            if (lastPathElem > 0) {
                String relPathParentStr = relPathStr.substring(0, lastPathElem);
                relPathStr = lastPathElem < relPathStr.length() - 1 ? relPathStr.substring(lastPathElem + 1) : "";
                NodeData pathParent = (NodeData)parents.get(relPathParentStr);
                parentNode = pathParent != null ? pathParent : this.parent;
            } else {
                parentNode = this.parent;
            }
            JCRPath path = this.locationFactory.createJCRPath(this.locationFactory.createJCRPath(parentNode.getQPath()), relPathStr);
            this.validatePath(path, parentNode, relPathStr);
            if (this.mixinTypeNames == null) {
                this.mixinTypeNames = new InternalQName[0];
            }
            InternalQName jcrName = path.getInternalPath().getName();
            InternalQPath dstNodePath = InternalQPath.makeChildPath((InternalQPath)parentNode.getQPath(), (InternalQName)jcrName);
            int nodeIndex = this.getNodeIndex(dstNodePath);
            TransientNodeData newNodeData = TransientNodeData.createNodeData(parentNode, jcrName, this.primaryTypeName, nodeIndex);
            newNodeData.setMixinTypeNames(this.mixinTypeNames);
            if (hasMixReferenceable) {
                newNodeData.setUUID(uuid);
            }
            this.itemStatesList.add(new ItemState((ItemData)newNodeData, 1, true, parentNode.getQPath()));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("node: " + newNodeData.getQPath().getAsString() + ", " + path.getIndex() + ", " + newNodeData.getUUID() + ", " + this.primaryTypeName.getAsString() + ", " + (this.mixinTypeNames.length > 0 ? this.mixinTypeNames[0].getAsString() + "..." : "")));
            }
            for (ParsedPropertyInfo prop : this.propsParsed) {
                List<ValueData> vDataList = prop.getValues();
                if (this.log.isDebugEnabled()) {
                    String vals = "";
                    for (ValueData vdata : vDataList) {
                        try {
                            vals = vals + new String(BLOBUtil.readValue((ValueData)vdata)) + (vDataList.lastIndexOf(vdata) != vDataList.size() - 1 ? "," : "");
                        }
                        catch (IOException e) {
                            this.log.error((Object)"Debug eror: ", (Throwable)e);
                        }
                        this.log.debug((Object)("prop(2): " + prop.getName().getAsString() + ", [" + vals + "], " + ExtendedPropertyType.nameFromValue((int)prop.getType())));
                    }
                }
                TransientPropertyData newProperty = null;
                if (prop.getName().equals((Object)Constants.JCR_UUID) && hasMixReferenceable) {
                    newProperty = TransientPropertyData.createPropertyData((NodeData)newNodeData, prop.getName(), prop.getType(), false, new TransientValueData(newNodeData.getUUID()));
                } else {
                    boolean isMultivalue = true;
                    PropertyDefinitions defs = this.ntManager.findPropertyDefinitions(prop.getName(), this.primaryTypeName, this.mixinTypeNames);
                    if (vDataList.size() == 1) {
                        if (defs.getDefinition(false) != null) {
                            isMultivalue = false;
                        }
                    } else if (defs.getDefinition(true) == null && defs.getDefinition(false) != null) {
                        throw new ValueFormatException("Can not assign multiple-values Value to a single-valued property " + prop.getName());
                    }
                    this.log.debug((Object)("Import " + prop.getName() + " size=" + vDataList.size() + " isMultivalue=" + isMultivalue));
                    newProperty = TransientPropertyData.createPropertyData((NodeData)newNodeData, prop.getName(), prop.getType(), isMultivalue, vDataList);
                }
                this.itemStatesList.add(new ItemState((ItemData)newProperty, 1, true, newNodeData.getQPath()));
            }
            parents.put(info.getRelPath(), newNodeData);
            if (i != 0) continue;
            node = newNodeData;
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("sv:node")) {
            try {
                String name = "";
                try {
                    name = atts.getValue("sv:name");
                }
                catch (IncompatibleClassChangeError e) {
                    e.printStackTrace();
                }
                String relPath = !this.tree.isEmpty() ? this.tree.peek().getRelPath() + "/" + name : name;
                NodeInfo info = new NodeInfo(relPath);
                this.tree.push(info);
                this.nodeInfos.add(info);
            }
            catch (Exception e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
        if (qName.equals("sv:property")) {
            try {
                this.curPropType = atts.getValue("sv:type");
                this.curPropName = atts.getValue("sv:name");
                this.curPropValues = new ArrayList<StringBuffer>();
            }
            catch (Exception e) {
                throw new SAXException(e.getMessage(), e);
            }
        } else if (qName.equals("sv:value")) {
            StringBuffer curPropValue = new StringBuffer();
            this.curPropValues.add(curPropValue);
        } else {
            throw new SAXException("'" + qName + "' is not allowed. Only sv:node, sv:property and sv:value are allowed");
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("sv:node")) {
            this.tree.pop();
        } else if (qName.equals("sv:property")) {
            this.tree.peek().addProperty(this.curPropName, this.curPropType, this.curPropValues);
        } else if (qName.equals("sv:value")) {
            // empty if block
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.curPropValues.size() > 0) {
            StringBuffer curPropValue = this.curPropValues.get(this.curPropValues.size() - 1);
            curPropValue.append(ch, start, length);
        } else {
            this.log.warn((Object)("Wrong XML content. Element 'sv:value' expected, but SAX event 'characters' occured. characters:[" + new String(ch) + "]"));
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        this.nodeInfos.clear();
    }

    public void endDocument() throws SAXException {
        try {
            this.buildNode();
        }
        catch (Exception e) {
            throw new SAXException("Error create node from System View document. Exception: " + e.getMessage(), e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public NodeIterator getNodes(NodeData parent, String namePattern) throws RepositoryException {
        List<NodeImpl> childNodes = this.session.getTransientNodesManager().getChildNodes(parent, true);
        NamePatternFilter filter = new NamePatternFilter(namePattern);
        ArrayList<NodeData> list = new ArrayList<NodeData>();
        for (NodeImpl item : childNodes) {
            if (!filter.accept(item)) continue;
            list.add((NodeData)item.getData());
        }
        return new EntityCollection(list);
    }

    private String traverseNodeInfo(String path, NodeInfo info) throws PathNotFoundException, RepositoryException {
        String uuid = null;
        List<PropertyInfo> props = info.getProperties();
        for (PropertyInfo prop : props) {
            InternalQName propName = this.locationFactory.parseJCRName(prop.getName()).getInternalName();
            List<StringBuffer> valueList = prop.getValues();
            if (propName.equals((Object)Constants.JCR_PRIMARYTYPE)) {
                if (valueList.size() > 0) {
                    this.primaryTypeName = this.locationFactory.parseJCRName(new String(valueList.get(0))).getInternalName();
                    this.nodeTypes.add(this.ntManager.getNodeType(this.primaryTypeName));
                } else {
                    this.log.warn((Object)("Imported property " + path + "/jcr:primaryType has empty value"));
                }
            } else if (propName.equals((Object)Constants.JCR_MIXINTYPES)) {
                if (valueList.size() > 0) {
                    this.mixinTypeNames = new InternalQName[valueList.size()];
                } else {
                    this.log.warn((Object)("Imported property " + path + "/jcr:mixinTypes has empty value(s)"));
                }
            } else if (propName.equals((Object)Constants.JCR_UUID)) {
                if (valueList.size() > 0) {
                    uuid = new String(valueList.get(0));
                } else {
                    this.log.warn((Object)("Imported property " + path + "/jcr:uuid has empty value"));
                }
            }
            ArrayList<ValueData> values = new ArrayList<ValueData>(valueList.size());
            String valStr = "";
            for (int k = 0; k < valueList.size(); ++k) {
                String val = new String(valueList.get(k));
                if (prop.getType() == 2) {
                    values.add(((BaseValue)this.session.getValueFactory().createValue(new ByteArrayInputStream(Base64.decodeBase64((byte[])val.getBytes())))).getInternalData());
                    continue;
                }
                values.add(((BaseValue)this.session.getValueFactory().createValue(val, prop.getType())).getInternalData());
                if (propName.equals((Object)Constants.JCR_MIXINTYPES)) {
                    this.mixinTypeNames[k] = this.locationFactory.parseJCRName(val).getInternalName();
                    this.nodeTypes.add(this.ntManager.getNodeType(this.mixinTypeNames[k]));
                }
                valStr = valStr + val + " ";
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("prop(1): " + prop.getName() + ", [" + valStr.trim() + "], " + ExtendedPropertyType.nameFromValue((int)prop.getType())));
            }
            this.propsParsed.add(new ParsedPropertyInfo(propName, prop.getType(), values));
        }
        return uuid;
    }

    private void validatePath(JCRPath path, NodeData parentNode, String relPathStr) {
        int depthIndex = path.getDepth() - parentNode.getQPath().getDepth();
        JCRPath.PathElement[] relPathElems = path.getRelPath(depthIndex);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("BUILD NODE, PREPARE: '" + parentNode.getQPath().getAsString() + "' + '" + relPathStr + "', check from depth: " + depthIndex));
        }
        for (int depth = 0; depth < relPathElems.length; ++depth) {
            JCRPath.PathElement pathElement = relPathElems[depth];
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("BUILD NODE, NODE: '" + pathElement.getAsString(true) + "', depth: " + depth));
            }
            try {
                NodeIterator snsNodes = this.getNodes(parentNode, pathElement.getAsString());
                if (depth < relPathElems.length - 1) {
                    relPathElems[depth] = pathElement = pathElement.clone((int)snsNodes.getSize());
                    try {
                        JCRPath parentPath = this.locationFactory.createJCRPath(this.locationFactory.createJCRPath(parentNode.getQPath()), pathElement.getAsString(false));
                        parentNode = (NodeData)this.session.getTransientNodesManager().getItemData(parentPath.getInternalPath());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("BUILD NODE, <<< NEW ANCESTOR for RELATIVE path >>> : '" + parentNode.getQPath().getAsString() + "', depth: " + depth + ", path: '" + path.getAsString(true) + "'"));
                        }
                    }
                    catch (PathNotFoundException e) {
                        this.log.warn((Object)("Next parent not found: '" + parentNode.getQPath().getAsString() + "', depth: " + depth + ", relPath: '" + path.getAsString(true) + "'"));
                    }
                } else if (depth == relPathElems.length - 1) {
                    relPathElems[depth] = pathElement = pathElement.clone((int)snsNodes.getSize() + 1);
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("BUILD NODE, FIX ANCESTOR: '" + parentNode.getQPath().getAsString() + "', depth: " + depth + ", path: '" + path.getAsString(true) + "'"));
                continue;
            }
            catch (PathNotFoundException e) {
                this.log.warn((Object)("Node not found: '" + parentNode.getQPath().getAsString() + "', depth: " + depth + ", relPath: '" + path.getAsString(true) + "'"));
                continue;
            }
            catch (RepositoryException e) {
                this.log.warn((Object)("Error of same-name-sibling nodes processing: " + e.getMessage() + ". Node: " + parentNode.getQPath().getAsString()));
            }
        }
    }

    private String validateUuidCollision(String uuid) throws AccessDeniedException, RepositoryException {
        String retUuid = uuid != null ? new String(uuid) : null;
        try {
            ItemDataRemoveVisitor visitor = null;
            NodeImpl sameUuidNode = (NodeImpl)this.session.getNodeByUUID(uuid);
            List<ItemState> removedStates = null;
            switch (this.uuidBehavior) {
                case 0: {
                    retUuid = UUIDGenerator.generate();
                    break;
                }
                case 1: {
                    visitor = new ItemDataRemoveVisitor(this.session.getTransientNodesManager());
                    sameUuidNode.getData().accept((ItemDataVisitor)visitor);
                    removedStates = visitor.getRemovedStates();
                    this.itemStatesList.addAll(removedStates);
                    break;
                }
                case 2: {
                    this.parent = (NodeData)((NodeImpl)sameUuidNode.getParent()).getData();
                    visitor = new ItemDataRemoveVisitor(this.session.getTransientNodesManager());
                    sameUuidNode.getData().accept((ItemDataVisitor)visitor);
                    removedStates = visitor.getRemovedStates();
                    this.itemStatesList.addAll(removedStates);
                    break;
                }
                case 3: {
                    throw new ItemExistsException("An incoming referenceable node has the same UUID as a node already existing in the workspace!");
                }
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        return retUuid;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertyInfo {
        private String name;
        private int type;
        private List<StringBuffer> values;

        public PropertyInfo(String name, int type, List<StringBuffer> values) {
            this.name = name;
            this.type = type;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public List<StringBuffer> getValues() {
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParsedPropertyInfo {
        private final InternalQName name;
        private final int type;
        private final List<ValueData> values;

        public ParsedPropertyInfo(InternalQName name, int type, List<ValueData> values) {
            this.name = name;
            this.type = type;
            this.values = values;
        }

        public InternalQName getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public List<ValueData> getValues() {
            return this.values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeInfo {
        private String relPath;
        private List<PropertyInfo> properties = new ArrayList<PropertyInfo>();

        public NodeInfo(String relPath) {
            this.relPath = relPath;
        }

        public void addProperty(String name, String typeName, List<StringBuffer> strValues) {
            int type = ExtendedPropertyType.valueFromName((String)typeName);
            PropertyInfo prop = new PropertyInfo(name, type, strValues);
            this.properties.add(prop);
        }

        public List<PropertyInfo> getProperties() {
            return this.properties;
        }

        public String getRelPath() {
            return this.relPath;
        }
    }
}

