/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.client;

import java.rmi.RemoteException;
import javax.jcr.Item;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.rmi.api.client.ClientObject;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRepositoryException;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRuntimeException;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteItem;

public class ClientItem
extends ClientObject
implements Item {
    private Session session;
    private RemoteItem remote;

    public ClientItem(Session session, RemoteItem remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Item) {
            Item anItem = (Item)obj;
            try {
                return this.isSame(anItem);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public Session getSession() {
        return this.session;
    }

    public String getPath() throws RepositoryException {
        try {
            return this.remote.getPath();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String getName() throws RepositoryException {
        try {
            return this.remote.getName();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Item getAncestor(int level) throws RepositoryException {
        try {
            return this.getItem(this.getSession(), this.remote.getAncestor(level));
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Node getParent() throws RepositoryException {
        try {
            return this.getNode(this.getSession(), this.remote.getParent());
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public int getDepth() throws RepositoryException {
        try {
            return this.remote.getDepth();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public boolean isNode() {
        return false;
    }

    public boolean isNew() {
        try {
            return this.remote.isNew();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isModified() {
        try {
            return this.remote.isModified();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isSame(Item item) throws RepositoryException {
        if (item == null) {
            return false;
        }
        if (super.equals(item)) {
            return true;
        }
        if (this.isNode() == item.isNode()) {
            return this.getPath().equals(item.getPath());
        }
        return false;
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
    }

    public void save() throws RepositoryException {
        try {
            this.remote.save();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        try {
            this.remote.refresh(keepChanges);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public void remove() throws RepositoryException {
        try {
            this.remote.remove();
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }
}

