/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.client;

import java.rmi.RemoteException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.rmi.api.client.ClientObject;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRuntimeException;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemoteNodeDefinition;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemoteNodeType;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemotePropertyDefinition;
import org.exoplatform.services.jcr.rmi.api.value.SerialValueFactory;

public class ClientNodeType
extends ClientObject
implements NodeType {
    private RemoteNodeType remote;

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof ClientNodeType) {
            ClientNodeType cnodetype = (ClientNodeType)obj;
            return this.getName().equals(cnodetype.getName());
        }
        return false;
    }

    public ClientNodeType(RemoteNodeType remote, LocalAdapterFactory factory) {
        super(factory);
        this.remote = remote;
    }

    private NodeDefinition[] getNodeDefArray(RemoteNodeDefinition[] remotes) {
        if (remotes != null) {
            NodeDefinition[] defs = new NodeDefinition[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                defs[i] = this.getFactory().getNodeDef(remotes[i]);
            }
            return defs;
        }
        return new NodeDefinition[0];
    }

    protected PropertyDefinition[] getPropertyDefArray(RemotePropertyDefinition[] remotes) {
        if (remotes != null) {
            PropertyDefinition[] defs = new PropertyDefinition[remotes.length];
            for (int i = 0; i < remotes.length; ++i) {
                defs[i] = this.getFactory().getPropertyDef(remotes[i]);
            }
            return defs;
        }
        return new PropertyDefinition[0];
    }

    public String getName() {
        try {
            return this.remote.getName();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isMixin() {
        try {
            return this.remote.isMixin();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean hasOrderableChildNodes() {
        try {
            return this.remote.hasOrderableChildNodes();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeType[] getSupertypes() {
        try {
            return this.getNodeTypeArray(this.remote.getSupertypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeType[] getDeclaredSupertypes() {
        try {
            return this.getNodeTypeArray(this.remote.getDeclaredSupertypes());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean isNodeType(String type) {
        try {
            return this.remote.isNodeType(type);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        try {
            return this.getPropertyDefArray(this.remote.getPropertyDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        try {
            return this.getPropertyDefArray(this.remote.getDeclaredPropertyDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        try {
            return this.getNodeDefArray(this.remote.getChildNodeDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        try {
            return this.getNodeDefArray(this.remote.getDeclaredChildNodeDefs());
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canSetProperty(String name, Value value) {
        try {
            return this.remote.canSetProperty(name, SerialValueFactory.makeSerialValue(value));
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canSetProperty(String name, Value[] values) {
        try {
            Value[] serials = SerialValueFactory.makeSerialValueArray(values);
            return this.remote.canSetProperty(name, serials);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canAddChildNode(String name) {
        try {
            return this.remote.canAddChildNode(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canAddChildNode(String name, String type) {
        try {
            return this.remote.canAddChildNode(name, type);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public boolean canRemoveItem(String name) {
        try {
            return this.remote.canRemoveItem(name);
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }

    public String getPrimaryItemName() {
        try {
            return this.remote.getPrimaryItemName();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }
}

