/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.client;

import java.rmi.RemoteException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.services.jcr.rmi.api.client.ClientObject;
import org.exoplatform.services.jcr.rmi.api.client.LocalAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRepositoryException;
import org.exoplatform.services.jcr.rmi.api.exceptions.RemoteRuntimeException;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteQuery;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteQueryManager;

public class ClientQueryManager
extends ClientObject
implements QueryManager {
    private Session session;
    private RemoteQueryManager remote;

    public ClientQueryManager(Session session, RemoteQueryManager remote, LocalAdapterFactory factory) {
        super(factory);
        this.session = session;
        this.remote = remote;
    }

    public Query createQuery(String statement, String language) throws RepositoryException {
        try {
            RemoteQuery query = this.remote.createQuery(statement, language);
            return this.getFactory().getQuery(this.session, query);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public Query getQuery(Node node) throws RepositoryException {
        try {
            RemoteQuery query = this.remote.getQuery(node.getPath());
            return this.getFactory().getQuery(this.session, query);
        }
        catch (RemoteException ex) {
            throw new RemoteRepositoryException(ex);
        }
    }

    public String[] getSupportedQueryLanguages() throws RepositoryException {
        try {
            return this.remote.getSupportedQueryLanguages();
        }
        catch (RemoteException ex) {
            throw new RemoteRuntimeException(ex);
        }
    }
}

