/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.api.xml;

import java.io.ByteArrayOutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class ImportContentHandler
implements ContentHandler,
ErrorHandler {
    private ByteArrayOutputStream buffer;
    private Session session;
    private TransformerHandler handler;

    public ImportContentHandler(Session session, String absPath) throws VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.session = session;
        this.checkNodeImport(absPath);
        this.buffer = new ByteArrayOutputStream();
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            this.handler = tf.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        Transformer serializer = this.handler.getTransformer();
        serializer.setOutputProperty("indent", "no");
        serializer.setOutputProperty("method", "xml");
        StreamResult streamResult = new StreamResult(this.buffer);
        this.handler.setResult(streamResult);
    }

    protected abstract void importXML(byte[] var1) throws Exception;

    public void setDocumentLocator(Locator locator) {
        this.handler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.handler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument();
        try {
            this.importXML(this.buffer.toByteArray());
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.handler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.handler.endPrefixMapping(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.handler.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handler.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.handler.characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.handler.ignorableWhitespace(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.handler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.handler.skippedEntity(name);
    }

    public void error(SAXParseException err) throws SAXException {
        this.errorErrorLog(null, err);
    }

    public void fatalError(SAXParseException err) throws SAXException {
        this.fatalErrorLog(null, err);
    }

    public void warning(SAXParseException err) throws SAXException {
        this.warnErrorLog(null, err);
    }

    private void warnErrorLog(String message, Throwable exception) {
        this.toErrorLog("[WARN] " + (message != null && message.length() > 0 ? message + "; " : ""), exception);
    }

    private void errorErrorLog(String message, Throwable exception) {
        this.toErrorLog("[ERROR] " + (message != null && message.length() > 0 ? message + "; " : ""), exception);
    }

    private void fatalErrorLog(String message, Throwable exception) {
        this.toErrorLog("[FATAL] " + (message != null && message.length() > 0 ? message + "; " : ""), exception);
    }

    private void toErrorLog(String message, Throwable exception) {
        String err = "ErrorHandler (exo-jcr NodeImporter) " + (message != null && message.length() > 0 ? message + ": " : "") + "Exception: " + exception;
        System.err.println(err);
        exception.printStackTrace(System.err);
    }

    private void checkNodeImport(String absNodePath) throws VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.checkNodeImport((Node)this.session.getItem(absNodePath));
    }

    private void checkNodeImport(Node node) throws VersionException, ConstraintViolationException, LockException, RepositoryException {
        if (!node.isCheckedOut()) {
            throw new VersionException("Node " + node.getPath() + " or its nearest ancestor is checked-in");
        }
        if (node.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + node.getName() + " to " + node.getParent().getPath());
        }
        if (node.isLocked()) {
            throw new LockException("Node " + node.getPath() + " is locked ");
        }
    }
}

