/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav;

import java.util.ArrayList;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.web.servlet.ServletWebContext;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.FakeLockTable;
import org.exoplatform.services.webdav.WebDavConfig;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavSessionProvider;
import org.exoplatform.services.webdav.request.WebDavRequest;
import org.exoplatform.services.webdav.request.WebDavRequestImpl;
import org.exoplatform.services.webdav.response.WebDavResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavCommandContext
extends ServletWebContext {
    private static Log log = ExoLogger.getLogger((String)"jcr.DavContext");
    protected WebDavService davService;
    protected WebDavRequest davRequest;
    protected WebDavResponse davResponse;
    protected WebDavSessionProvider sessionProvider;

    public WebDavCommandContext(ServletContext context, HttpServletRequest request, HttpServletResponse response, WebDavService davService) throws Exception {
        super(context, request, response);
        this.davService = davService;
        this.davRequest = new WebDavRequestImpl(request, davService.getPropertyFactory());
        this.davResponse = new WebDavResponse(response);
        ManageableRepository repository = davService.getRepository();
        this.sessionProvider = new WebDavSessionProvider(davService, (Repository)davService.getRepository());
    }

    public WebDavConfig getConfig() {
        return this.davService.getConfig();
    }

    public WebDavSessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    public FakeLockTable getLockTable() {
        return this.davService.getLockTable();
    }

    public WebDavRequest getWebDavRequest() {
        return this.davRequest;
    }

    public WebDavResponse getWebDavResponse() {
        return this.davResponse;
    }

    public ArrayList<String> getAvailableCommands() {
        return this.davService.getAvailableCommands();
    }

    public String[] getAvailableWorkspaces() {
        try {
            return this.davService.getRepository().getWorkspaceNames();
        }
        catch (RepositoryException exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()));
        }
        catch (RepositoryConfigurationException exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()));
        }
        return null;
    }
}

