/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.commons.chain.Catalog;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.FakeLockTable;
import org.exoplatform.services.webdav.MappingLoader;
import org.exoplatform.services.webdav.PropertyConfigLoader;
import org.exoplatform.services.webdav.WebDavConfig;
import org.exoplatform.services.webdav.WebDavConfigImpl;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavServiceImpl
implements WebDavService {
    private static Log log = ExoLogger.getLogger((String)"jcr.WebDavServiceImpl");
    public static final String COMMANDS_PATH = "/conf/webdav-commands.xml";
    public static final String MAPPING_PATH = "/conf/webdav-mapping-table.xml";
    public static final String PROPERTYCONFIG_PATH = "/conf/webdav-propertyconfig.xml";
    protected RepositoryService repositoryService;
    protected Catalog commandCatalog;
    protected WebDavConfig config;
    protected FakeLockTable lockTable;
    protected PropertyFactory propertyFactory;

    public WebDavServiceImpl(InitParams params, CommandService commandService, RepositoryService repositoryService) throws Exception {
        this.repositoryService = repositoryService;
        InputStream commandsStream = this.getClass().getResourceAsStream(COMMANDS_PATH);
        commandService.putCatalog(commandsStream);
        this.commandCatalog = commandService.getCatalog("WEBDAV");
        if (this.commandCatalog == null) {
            CommandService curService = new CommandService();
            InputStream curCommandsStream = this.getClass().getResourceAsStream(COMMANDS_PATH);
            curService.putCatalog(curCommandsStream);
            this.commandCatalog = curService.getCatalog("WEBDAV");
            if (this.commandCatalog == null) {
                log.info((Object)"CAN'T GET COMMAND CATALOG");
            }
        }
        this.config = new WebDavConfigImpl(params);
        this.lockTable = new FakeLockTable();
        this.initPropertySettings();
    }

    private void initPropertySettings() throws Exception {
        InputStream mappingStream = this.getClass().getResourceAsStream(MAPPING_PATH);
        MappingLoader mappingLoader = new MappingLoader(mappingStream);
        InputStream configStream = this.getClass().getResourceAsStream(PROPERTYCONFIG_PATH);
        PropertyConfigLoader configLoader = new PropertyConfigLoader(configStream);
        this.propertyFactory = new PropertyFactory(mappingLoader.getMappingTable(), configLoader.getConfigTable());
    }

    @Override
    public WebDavConfig getConfig() {
        return this.config;
    }

    @Override
    public ArrayList<String> getAvailableCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        Iterator commandIter = this.commandCatalog.getNames();
        while (commandIter.hasNext()) {
            String curCommand = (String)commandIter.next();
            commands.add(curCommand);
        }
        return commands;
    }

    @Override
    public WebDavCommand getCommand(String commandName) {
        WebDavCommand command = (WebDavCommand)this.commandCatalog.getCommand(commandName);
        return command;
    }

    @Override
    public ManageableRepository getRepository() throws RepositoryException, RepositoryConfigurationException {
        String repositoryName = this.config.getRepositoryName();
        if (repositoryName == null) {
            return this.repositoryService.getRepository();
        }
        return this.repositoryService.getRepository(repositoryName);
    }

    @Override
    public FakeLockTable getLockTable() {
        return this.lockTable;
    }

    @Override
    public PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }
}

