/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import org.exoplatform.services.webdav.FakeLockTable;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.property.dav.LockDiscoveryProp;
import org.exoplatform.services.webdav.property.factory.PropertyDefine;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.request.documents.LockInfoDoc;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DeltaVResource;
import org.exoplatform.services.webdav.resource.FakeResource;
import org.exoplatform.services.webdav.resource.NodeResource;

public class LockCommand
extends WebDavCommand {
    protected boolean process() throws RepositoryException {
        RequestDocument requestDoc = this.davRequest().getDocumentFromRequest();
        if (requestDoc == null) {
            requestDoc = new LockInfoDoc();
        } else if (!(requestDoc instanceof LockInfoDoc)) {
            this.davResponse().setStatus(412);
            return false;
        }
        DavResource resource = this.getResourceFactory().getSrcResource(true);
        if (resource instanceof FakeResource) {
            this.doFakeLock((LockInfoDoc)requestDoc);
            return true;
        }
        if (!(resource instanceof NodeResource) && !(resource instanceof DeltaVResource)) {
            throw new AccessDeniedException();
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        if (!node.isNodeType("mix:lockable")) {
            node.addMixin("mix:lockable");
            node.getSession().save();
        }
        Lock lockResult = node.lock(true, false);
        node.getSession().save();
        PropertyFactory factory = this.davRequest().getPropertyFactory();
        PropertyDefine define = factory.getDefine("DAV:", "lockdiscovery");
        LockDiscoveryProp lockDiscovery = (LockDiscoveryProp)define.getProperty();
        lockDiscovery.refresh123(resource, null);
        lockDiscovery.setLockToken(lockResult.getLockToken());
        this.replyLockDiscovery(lockDiscovery);
        return true;
    }

    private void doFakeLock(LockInfoDoc lockDoc) {
        FakeLockTable lockTable = this.davContext().getLockTable();
        String resourcePath = this.davRequest().getSrcWorkspace() + this.davRequest().getSrcPath();
        String lockToken = lockTable.lockResource(resourcePath);
        LockDiscoveryProp lockDiscovery = new LockDiscoveryProp();
        lockDiscovery.setLocked(true);
        lockDiscovery.setOwner(lockDoc.getLockOwner());
        lockDiscovery.setLockToken(lockToken);
        lockDiscovery.setStatus(200);
        this.replyLockDiscovery(lockDiscovery);
    }

    private void replyLockDiscovery(LockDiscoveryProp lockDiscovery) {
        this.davResponse().setResponseHeader("Lock-Token", "<" + lockDiscovery.getLockToken() + ">");
        this.davResponse().setProperty(lockDiscovery);
    }
}

