/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.commands;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.commands.WebDavCommand;
import org.exoplatform.services.webdav.order.OrderMember;
import org.exoplatform.services.webdav.request.documents.OrderPatchDoc;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.NodeResource;
import org.exoplatform.services.webdav.response.Href;
import org.exoplatform.services.webdav.response.MultiStatus;
import org.exoplatform.services.webdav.response.Response;
import org.exoplatform.services.webdav.response.ResponseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderPatchCommand
extends WebDavCommand {
    @Override
    protected boolean process() throws RepositoryException {
        ArrayList<OrderMember> members;
        RequestDocument reqDoc = this.davRequest().getDocumentFromRequest();
        if (!(reqDoc instanceof OrderPatchDoc)) {
            this.davResponse().answerPreconditionFailed();
            return false;
        }
        DavResource resource = this.getResourceFactory().getSrcResource(false);
        if (!(resource instanceof NodeResource)) {
            this.davResponse().answerForbidden();
            return false;
        }
        Node node = ((NodeResource)resource).getNode();
        MultiStatus multistatus = this.doOrder(node, members = ((OrderPatchDoc)reqDoc).getMembers());
        if (multistatus == null) {
            this.davResponse().answerOk();
            return true;
        }
        this.davResponse().setMultistatus(multistatus);
        return true;
    }

    private MultiStatus doOrder(Node node, ArrayList<OrderMember> members) {
        ArrayList<Response> responses = new ArrayList<Response>();
        for (int i = 0; i < members.size(); ++i) {
            OrderMember member = members.get(i);
            Response response = this.doOrderMember(node, member);
            if (response == null) continue;
            responses.add(response);
        }
        if (responses.size() == 0) {
            return null;
        }
        return new MultiStatus(responses);
    }

    private Response doOrderMember(Node node, OrderMember member) {
        String href = this.davRequest().getServerPrefix() + "/" + this.davRequest().getSrcWorkspace() + this.davRequest().getSrcPath() + "/" + member.getSegment();
        int status = -1;
        String description = "";
        try {
            this.doOrderNode(node, member);
            status = 200;
        }
        catch (PathNotFoundException pexc) {
            status = 404;
            description = "Required segment not found";
        }
        catch (AccessDeniedException aexc) {
            status = 403;
            description = "Forbidden";
        }
        catch (RepositoryException rexc) {
            status = 409;
            description = "Unhandled error during execution";
        }
        if (status == 200) {
            return null;
        }
        ResponseImpl response = new ResponseImpl();
        response.setHref(new Href(this.davContext(), href));
        response.setStatus(status);
        response.setDescription(description);
        return response;
    }

    private void doOrderNode(Node parentNode, OrderMember member) throws RepositoryException {
        String positionedNodeName = null;
        if (!parentNode.hasNode(member.getSegment())) {
            throw new PathNotFoundException();
        }
        if (1 != member.getposition()) {
            NodeIterator nodes = parentNode.getNodes();
            boolean finded = false;
            while (nodes.hasNext()) {
                Node curNode = nodes.nextNode();
                if (0 == member.getposition()) {
                    positionedNodeName = curNode.getName();
                    finded = true;
                    break;
                }
                if (2 == member.getposition() && curNode.getName().equals(member.getpositionSegment())) {
                    positionedNodeName = curNode.getName();
                    finded = true;
                    break;
                }
                if (3 != member.getposition() || !curNode.getName().equals(member.getpositionSegment())) continue;
                if (nodes.hasNext()) {
                    Node nextNode = nodes.nextNode();
                    positionedNodeName = nextNode.getName();
                    finded = true;
                    break;
                }
                finded = true;
                break;
            }
            if (!finded) {
                throw new AccessDeniedException();
            }
        }
        parentNode.orderBefore(member.getSegment(), positionedNodeName);
        parentNode.getSession().save();
    }
}

