/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContentLengthProp
extends AbstractDAVProperty {
    protected long contentLength = 0L;

    public ContentLengthProp() {
        super("getcontentlength");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (!(resource instanceof AbstractNodeResource)) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        if (node.isNodeType("nt:version")) {
            node = node.getNode("jcr:frozenNode");
        }
        Node dataNode = node.getNode("jcr:content");
        Property dataProperty = dataNode.getProperty("jcr:data");
        this.contentLength = dataProperty.getLength();
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        this.propertyElement.setTextContent("" + this.contentLength);
    }
}

