/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.DeltaVResource;
import org.exoplatform.services.webdav.resource.NodeResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LastModifiedProp
extends AbstractDAVProperty {
    protected String lastModified = "";

    public LastModifiedProp() {
        super("getlastmodified");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (!(resource instanceof NodeResource) && !(resource instanceof DeltaVResource)) {
            return false;
        }
        if (resource.isCollection()) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        Node contentNode = node.getNode("jcr:content");
        Property lastModifiedProp = contentNode.getProperty("jcr:lastModified");
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.lastModified = dateFormat.format(lastModifiedProp.getDate().getTime());
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        this.propertyElement.setTextContent(this.lastModified);
    }
}

