/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.RepositoryResource;
import org.exoplatform.services.webdav.resource.WorkspaceResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParentNameProp
extends AbstractDAVProperty {
    private String parentName = "";

    public ParentNameProp() {
        super("parentname");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (resource instanceof RepositoryResource) {
            return false;
        }
        if (resource instanceof WorkspaceResource) {
            this.parentName = "/";
            this.status = 200;
            return true;
        }
        if (!(resource instanceof AbstractNodeResource)) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        this.parentName = node.getDepth() > 1 ? node.getParent().getName() : node.getSession().getWorkspace().getName();
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        this.propertyElement.setTextContent(this.parentName);
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentName() {
        return this.parentName;
    }
}

