/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;
import org.exoplatform.services.webdav.resource.VersionResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedLockProp
extends AbstractDAVProperty {
    public SupportedLockProp() {
        super("supportedlock");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        if (!(resource instanceof AbstractNodeResource) || resource instanceof VersionResource) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        if (!node.canAddMixin("mix:lockable")) {
            return false;
        }
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        Element dLockEntry = rootDoc.createElement("D:lockentry");
        this.propertyElement.appendChild(dLockEntry);
        Element dLockScope = rootDoc.createElement("D:lockscope");
        dLockEntry.appendChild(dLockScope);
        Element dExclusive = rootDoc.createElement("D:exclusive");
        dLockScope.appendChild(dExclusive);
        Element dLockType = rootDoc.createElement("D:locktype");
        dLockEntry.appendChild(dLockType);
        Element dWrite = rootDoc.createElement("D:write");
        dLockType.appendChild(dWrite);
    }
}

