/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.dav;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.QueryManager;
import org.exoplatform.services.webdav.property.dav.AbstractDAVProperty;
import org.exoplatform.services.webdav.resource.DavResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedQueryGrammarSetProp
extends AbstractDAVProperty {
    private ArrayList<String> queryGrammars = new ArrayList();

    public SupportedQueryGrammarSetProp() {
        super("supported-query-grammar-set");
    }

    protected boolean initialize(DavResource resource) throws RepositoryException {
        Session session = resource.getSession();
        if (session == null) {
            return false;
        }
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String[] supportedLanguages = queryManager.getSupportedQueryLanguages();
        for (int i = 0; i < supportedLanguages.length; ++i) {
            this.queryGrammars.add(supportedLanguages[i]);
        }
        this.status = 200;
        return true;
    }

    public void serialize(Document rootDoc, Element parentElement) {
        super.serialize(rootDoc, parentElement);
        if (this.status != 200) {
            return;
        }
        Element supportedQueryGrammarEl = rootDoc.createElement("D:supported-query-grammar");
        this.propertyElement.appendChild(supportedQueryGrammarEl);
        Element grammarEl = rootDoc.createElement("D:grammar");
        supportedQueryGrammarEl.appendChild(grammarEl);
        Element basicSearchEl = rootDoc.createElement("D:basicsearch");
        grammarEl.appendChild(basicSearchEl);
        for (int i = 0; i < this.queryGrammars.size(); ++i) {
            Element supportedQueryGrammarEl2 = rootDoc.createElement("D:supported-query-grammar");
            this.propertyElement.appendChild(supportedQueryGrammarEl2);
            Element grammarEl2 = rootDoc.createElement("D:grammar");
            supportedQueryGrammarEl2.appendChild(grammarEl2);
            Element syntaxEl = rootDoc.createElementNS("http://exoplatform.com/jcr", "exo:" + this.queryGrammars.get(i));
            grammarEl2.appendChild(syntaxEl);
        }
    }
}

