/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.property.factory;

import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.property.WebDavProperty;
import org.exoplatform.services.webdav.property.factory.PropertyConfig;
import org.exoplatform.services.webdav.resource.AbstractNodeResource;
import org.exoplatform.services.webdav.resource.DavResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyConfigTable {
    private static Log log = ExoLogger.getLogger((String)"jcr.PropertyConfigTable");
    private HashMap<String, PropertyConfig> configurations = new HashMap();

    public void setPropertyConfiguration(String nodeTypeName, PropertyConfig propertyConfig) {
        this.configurations.put(nodeTypeName, propertyConfig);
    }

    public ArrayList<String> getIncludes(String nodeTypeName) {
        PropertyConfig config = this.configurations.get(nodeTypeName);
        if (config == null && (config = this.configurations.get("*")) == null) {
            return new ArrayList<String>();
        }
        return config.getIncludes();
    }

    public boolean isNeedExclude(DavResource resource, String propertyName) throws RepositoryException {
        if (!(resource instanceof AbstractNodeResource)) {
            return false;
        }
        Node node = ((AbstractNodeResource)resource).getNode();
        String nodeType = node.getPrimaryNodeType().getName();
        PropertyConfig curConfig = this.configurations.get(nodeType);
        if (curConfig == null && (curConfig = this.configurations.get("*")) == null) {
            return false;
        }
        if (propertyName.indexOf(":") < 0) {
            propertyName = "DAV:" + propertyName;
        }
        return curConfig.isNeedExclude(propertyName);
    }

    public boolean isNeedExclude(DavResource resource, WebDavProperty property) throws RepositoryException {
        return this.isNeedExclude(resource, property.getName());
    }
}

