/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.request;

import javax.servlet.http.HttpServletRequest;
import org.exoplatform.services.webdav.DavTextUtil;

public class DavPathUtil {
    public static String getServerPrefix(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + String.format("%s", request.getServerPort()) + request.getContextPath() + request.getServletPath();
    }

    public static String getServletApp(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + String.format("%s", request.getServerPort()) + request.getContextPath();
    }

    public static String getWorkspace(String path) {
        String[] pathes;
        String workPath = path;
        if (workPath == null) {
            workPath = "/";
        }
        if ((pathes = workPath.split("/")).length < 2) {
            return "";
        }
        return DavTextUtil.UnEscape(pathes[1], '%');
    }

    public static String getPath(String path) {
        String workspacePrefix;
        String workPath = path;
        if (workPath == null) {
            workPath = "/";
        }
        if (workPath.startsWith(workspacePrefix = "/" + DavPathUtil.getWorkspace(workPath))) {
            workPath = workPath.substring(workspacePrefix.length());
        }
        if (!workPath.startsWith("/")) {
            workPath = "/" + workPath;
        }
        if (workPath.endsWith("/") && !workPath.equals("/")) {
            workPath = workPath.substring(0, workPath.length() - 1);
        }
        return DavTextUtil.UnEscape(workPath, '%');
    }

    public static String getSrcWorkspace(HttpServletRequest request) {
        return DavPathUtil.getWorkspace(request.getPathInfo());
    }

    public static String getSrcPath(HttpServletRequest request) {
        return DavPathUtil.getPath(request.getPathInfo());
    }

    public static boolean isSameDestHost(HttpServletRequest request, String serverPrefix) {
        String destinationHeader = request.getHeader("Destination");
        return destinationHeader.startsWith(serverPrefix);
    }

    public static String getLocalDestPath(HttpServletRequest request) {
        String serverPrefix = DavPathUtil.getServerPrefix(request);
        String destinationHeader = request.getHeader("Destination");
        if (!destinationHeader.startsWith(serverPrefix)) {
            return "/";
        }
        return destinationHeader.substring(serverPrefix.length());
    }

    public static String getDestWorkspace(HttpServletRequest request) {
        return DavPathUtil.getWorkspace(DavPathUtil.getLocalDestPath(request));
    }

    public static String getDestPath(HttpServletRequest request) {
        return DavPathUtil.getPath(DavPathUtil.getLocalDestPath(request));
    }
}

