/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.request;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.exoplatform.services.webdav.WebDavSessionProvider;
import org.exoplatform.services.webdav.property.factory.PropertyFactory;
import org.exoplatform.services.webdav.request.DavPathUtil;
import org.exoplatform.services.webdav.request.DocumentFactory;
import org.exoplatform.services.webdav.request.WebDavRequest;
import org.exoplatform.services.webdav.request.documents.PropFindDoc;
import org.exoplatform.services.webdav.request.documents.RequestDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavRequestImpl
extends HttpServletRequestWrapper
implements WebDavRequest {
    private static Log log = ExoLogger.getLogger((String)"jcr.WebDavRequestImpl");
    protected String serverPrefix;
    protected String serverApp;
    protected String sourcePath;
    protected String sourceWorkspace;
    protected String sourceVersion;
    protected String destinationPath;
    protected String destinationWorkspace;
    protected String destinationVersion;
    protected long rangeStart = -1L;
    protected long rangeEnd = -1L;
    protected PropertyFactory propertyFactory;

    public WebDavRequestImpl(HttpServletRequest request, PropertyFactory propertyFactory) {
        super(request);
        String rangeString;
        String[] ranges;
        String rangeHeader;
        this.propertyFactory = propertyFactory;
        this.serverPrefix = DavPathUtil.getServerPrefix((HttpServletRequest)this);
        this.serverApp = DavPathUtil.getServletApp((HttpServletRequest)this);
        this.sourceWorkspace = DavPathUtil.getSrcWorkspace((HttpServletRequest)this);
        this.sourcePath = DavPathUtil.getSrcPath((HttpServletRequest)this);
        if (request.getParameter("VERSIONID") != null) {
            this.sourceVersion = request.getParameter("VERSIONID");
        } else if (this.sourcePath.indexOf("?") >= 0) {
            this.sourceVersion = this.sourcePath.substring(this.sourcePath.indexOf("?") + 1);
            this.sourceVersion = this.sourceVersion.substring("VERSIONID".length() + 1);
            this.sourcePath = this.sourcePath.substring(0, this.sourcePath.indexOf("?"));
        }
        if (this.getHeader("Destination") != null) {
            this.destinationWorkspace = DavPathUtil.getDestWorkspace((HttpServletRequest)this);
            this.destinationPath = DavPathUtil.getDestPath((HttpServletRequest)this);
        }
        if ((rangeHeader = this.getHeader("Range")) != null && rangeHeader.startsWith("bytes=") && (ranges = (rangeString = rangeHeader.substring(rangeHeader.indexOf("=") + 1)).split("-")).length > 0) {
            this.rangeStart = new Long(ranges[0]);
            if (ranges.length > 1) {
                this.rangeEnd = new Long(ranges[1]);
            }
        }
        if (log.isDebugEnabled()) {
            Enumeration hEnum = this.getHeaderNames();
            while (hEnum.hasMoreElements()) {
                String curHeaderName = (String)hEnum.nextElement();
                String curHeaderValue = this.getHeader(curHeaderName);
                log.debug((Object)("HEADER: [" + curHeaderName + "] VALUES [" + curHeaderValue + "]"));
            }
        }
    }

    @Override
    public PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    @Override
    public String getNodeType() {
        String nodetypeHeader = this.getHeader("NodeType");
        if (nodetypeHeader == null) {
            return null;
        }
        String nodeType = new String(Base64.decodeBase64((byte[])nodetypeHeader.getBytes()));
        return nodeType;
    }

    @Override
    public ArrayList<String> getMixTypes() {
        String mixTypesHeader = this.getHeader("MixType");
        if (mixTypesHeader == null) {
            mixTypesHeader = "";
        }
        String mixTypes = new String(Base64.decodeBase64((byte[])mixTypesHeader.getBytes()));
        String[] mixType = mixTypes.split(";");
        ArrayList<String> mixinTypes = new ArrayList<String>();
        for (int i = 0; i < mixType.length; ++i) {
            String curMixType = mixType[i];
            if ("".equals(curMixType)) continue;
            mixinTypes.add(curMixType);
        }
        return mixinTypes;
    }

    @Override
    public ArrayList<String> getLockTokens() {
        String ifHeaderValue;
        ArrayList<String> lockTokens = new ArrayList<String>();
        String lockToken = this.getHeader("Lock-Token");
        if (lockToken != null) {
            lockToken = lockToken.substring(1, lockToken.length() - 1);
            lockTokens.add(lockToken);
        }
        if ((ifHeaderValue = this.getHeader("If")) != null) {
            String headerLockToken = ifHeaderValue.substring(ifHeaderValue.indexOf("("));
            headerLockToken = headerLockToken.substring(2, headerLockToken.length() - 2);
            lockTokens.add(headerLockToken);
        }
        return lockTokens;
    }

    protected void fillLockTokens(Session session) {
        if (session == null) {
            return;
        }
        ArrayList<String> lockTokens = this.getLockTokens();
        for (int i = 0; i < lockTokens.size(); ++i) {
            String curLockToken = lockTokens.get(i);
            session.addLockToken(curLockToken);
        }
    }

    @Override
    public Session getSourceSession(WebDavSessionProvider sessionProvider) throws RepositoryException {
        String authHeader = this.getHeader("Authorization");
        Session sourceSession = sessionProvider.getSession(authHeader, this.getSrcWorkspace());
        this.fillLockTokens(sourceSession);
        return sourceSession;
    }

    @Override
    public Session getDestinationSession(WebDavSessionProvider sessionProvider) throws RepositoryException {
        String authHeader = this.getHeader("Authorization");
        Session destinationSession = sessionProvider.getSession(authHeader, this.getDestWorkspace());
        this.fillLockTokens(destinationSession);
        return destinationSession;
    }

    @Override
    public Session getSession(WebDavSessionProvider sessionProvider, String workspaceName) throws RepositoryException {
        String authHeader = this.getHeader("Authorization");
        Session session = sessionProvider.getSession(authHeader, workspaceName);
        this.fillLockTokens(session);
        return session;
    }

    @Override
    public boolean isSameHosts() {
        return DavPathUtil.isSameDestHost((HttpServletRequest)this, this.getServerPrefix());
    }

    @Override
    public String getServerPrefix() {
        return this.serverPrefix;
    }

    @Override
    public String getServerApp() {
        return this.serverApp;
    }

    @Override
    public String getSrcWorkspace() {
        return this.sourceWorkspace;
    }

    @Override
    public String getSrcPath() {
        return this.sourcePath;
    }

    @Override
    public String getSrcVersion() {
        return this.sourceVersion;
    }

    @Override
    public String getDestWorkspace() {
        return this.destinationWorkspace;
    }

    @Override
    public String getDestPath() {
        return this.destinationPath;
    }

    @Override
    public RequestDocument getDocumentFromRequest() {
        try {
            Document doc = DavUtil.GetDocumentFromRequest((HttpServletRequest)this);
            if (doc == null) {
                if ("PROPFIND".equals(this.getMethod())) {
                    PropFindDoc propsDoc = new PropFindDoc();
                    propsDoc.initFactory(this.propertyFactory);
                    return propsDoc;
                }
                return null;
            }
            Node documentNode = doc.getChildNodes().item(0);
            if (!"DAV:".equals(documentNode.getNamespaceURI())) {
                log.info((Object)"Input document namespace not equals DAV:");
                return null;
            }
            String documentName = documentNode.getLocalName();
            RequestDocument requestDocument = null;
            for (int i = 0; i < DocumentFactory.AVAILABLE_DOCUMENTS.length; ++i) {
                if (!documentName.equals(DocumentFactory.AVAILABLE_DOCUMENTS[i][0])) continue;
                requestDocument = (RequestDocument)Class.forName(DocumentFactory.AVAILABLE_DOCUMENTS[i][1]).newInstance();
            }
            if (requestDocument == null) {
                return null;
            }
            if (!requestDocument.init(doc, this.propertyFactory)) {
                return null;
            }
            return requestDocument;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    @Override
    public InputStream getRequestStream() throws Exception {
        return this.getInputStream();
    }

    @Override
    public String getContentType() {
        return this.getHeader("Content-type");
    }

    @Override
    public int getDepth() {
        String depthValue = this.getHeader("Depth");
        int depth = depthValue == null ? 1 : (depthValue.equalsIgnoreCase("Infinity") ? Integer.MAX_VALUE : new Integer(depthValue));
        if (depth < 1) {
            depth = 1;
        }
        return depth;
    }

    @Override
    public long getRangeStart() {
        return this.rangeStart;
    }

    @Override
    public long getRangeEnd() {
        return this.rangeEnd;
    }
}

