/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.response;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.DavUtil;
import org.exoplatform.services.webdav.property.WebDavProperty;
import org.exoplatform.services.webdav.response.MultiStatus;

public class WebDavResponse
extends HttpServletResponseWrapper {
    private static Log log = ExoLogger.getLogger((String)"jcr.WebDavResponse");
    private HttpServletResponse response;

    public WebDavResponse(HttpServletResponse response) {
        super(response);
        this.response = response;
    }

    public void setMultistatus(MultiStatus multistatus) {
        try {
            DavUtil.sendMultistatus(this.response, multistatus);
        }
        catch (Exception exc) {
            log.info((Object)("Can't send MULTISTATUS. " + exc.getMessage()), (Throwable)exc);
        }
    }

    public void setProperty(WebDavProperty property) {
        try {
            DavUtil.sendSingleProperty(this.response, property);
        }
        catch (Exception exc) {
            log.info((Object)("Can't send property. " + exc.getMessage()));
            exc.printStackTrace();
        }
    }

    public void setResponseHeader(String headerName, String headerValue) {
        if (headerValue == null) {
            return;
        }
        this.addHeader(headerName, headerValue);
    }

    public void answerUnAuthorized(String wwwAuthencticate) {
        this.addHeader("WWW-Authenticate", wwwAuthencticate);
        this.setStatus(401);
    }

    public void answerOk() {
        this.addHeader("Cache-Control", "no-cache");
        this.setStatus(200);
    }

    public void answerCreated() {
        this.setStatus(201);
    }

    public void answerNoContent() {
        this.setStatus(204);
    }

    public void answerNotFound() {
        this.setStatus(404);
    }

    public void answerForbidden() {
        this.setStatus(403);
    }

    public void answerPreconditionFailed() {
        this.setStatus(412);
    }

    public void answerNotImplemented() {
        this.setStatus(501);
    }

    public void writeToResponse(byte[] data, int len) throws IOException {
        this.getOutputStream().write(data, 0, len);
    }
}

