/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.search.basicsearch.convertor;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.exoplatform.services.webdav.search.basicsearch.convertor.DynamicXSD;
import org.xml.sax.SAXParseException;

public class SaxValidator {
    private StreamSource schema;
    private File xml_file;
    private String xml;
    private String dasl_prefix;
    private String xmlns = "xmlns:";

    public SaxValidator(String xml) {
        this.xml = new String(xml);
        this.xml = this.xml.replaceFirst("DAV:", "DAV:/");
        this.definePrefixes(this.xml);
        DynamicXSD dxsd = new DynamicXSD(this.dasl_prefix);
        StringReader xsd_sr = new StringReader(dxsd.xsd);
        this.schema = new StreamSource(xsd_sr);
    }

    public SaxValidator(File xml_file, File schema) {
        this.schema = new StreamSource(schema);
        this.xml_file = xml_file;
    }

    public void validateSource(String s) throws Exception {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(this.schema);
            spf.setSchema(schema);
            spf.setNamespaceAware(true);
            spf.setValidating(true);
            Validator v = schema.newValidator();
            StringReader sr = new StringReader(s);
            v.validate(new StreamSource(sr));
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void definePrefixes(String s) {
        int end = s.indexOf("DAV:/");
        int start = s.lastIndexOf(this.xmlns, end);
        this.dasl_prefix = s.substring(start + this.xmlns.length(), end - 1);
        this.dasl_prefix = this.dasl_prefix.replaceAll("=", " ");
        this.dasl_prefix = this.dasl_prefix.trim() + ":";
    }

    public String getDASLPrefix() {
        return this.dasl_prefix;
    }

    public void validate() throws Exception {
        if (this.xml_file == null) {
            this.validateSource(this.xml);
        } else {
            this.validateSource(this.readStringFromFile(this.xml_file));
        }
    }

    public String readStringFromFile(File file) throws Exception {
        String s = file.toString();
        FileInputStream f = new FileInputStream(s);
        int size = ((InputStream)f).available();
        byte[] b = new byte[size];
        ((InputStream)f).read(b);
        ((InputStream)f).close();
        s = new String(b);
        return s;
    }

    private void fail(Exception e) {
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            System.err.printf("line: %d column: %d message: %s%n", spe.getLineNumber(), spe.getColumnNumber(), spe.getMessage());
        } else {
            System.err.println(e.getMessage());
        }
    }
}

