/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.search.basicsearch.convertor.dasl;

import java.util.Enumeration;
import java.util.Vector;
import org.exoplatform.services.webdav.search.basicsearch.convertor.dasl.DASLVisitor;

public class DASLDocument {
    ElementSequence elements;

    public DASLDocument(ElementSequence s) {
        this.elements = s;
    }

    public ElementSequence getElements() {
        return this.elements;
    }

    public void accept(DASLVisitor v) {
        v.visit(this);
    }

    public static class ElementSequence {
        protected Vector<DASLElement> elements;

        public ElementSequence(int n) {
            this.elements = new Vector(n);
        }

        public ElementSequence() {
            this.elements = new Vector();
        }

        public void addElement(DASLElement o) {
            this.elements.addElement(o);
        }

        public Enumeration elements() {
            return this.elements.elements();
        }
    }

    public static class AttributeList {
        public Vector<Attribute> attributes = new Vector();

        public void addAttribute(Attribute a) {
            this.attributes.addElement(a);
        }
    }

    public static class Attribute {
        public String name;
        public String value;
        public boolean hasValue;

        public Attribute(String n) {
            this.name = n;
            this.hasValue = false;
        }

        public Attribute(String n, String v) {
            this.name = n;
            this.value = v;
            this.hasValue = true;
        }

        public int getLength() {
            return this.hasValue ? this.name.length() + 1 + this.value.length() : this.name.length();
        }

        public String toString() {
            return this.hasValue ? this.name + "=" + this.value : this.name;
        }
    }

    public static class NewLine
    extends DASLElement {
        public String type = "NL";
        private String tag_name = "";
        public static final String NL = System.getProperty("line.separator");

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.tag_name;
        }

        public void accept(DASLVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return NL.length();
        }

        public String toString() {
            return NL;
        }
    }

    public static class EmptyTag
    extends DASLElement {
        private String type = "empty_tag";
        private String tag_name;

        public EmptyTag(String t) {
            this.tag_name = t;
        }

        public String getName() {
            return this.tag_name;
        }

        public void setName(String t) {
            this.tag_name = t;
        }

        public String getType() {
            return this.type;
        }

        public void accept(DASLVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 3 + this.tag_name.length();
        }

        public String toString() {
            return "<" + this.tag_name + "/>";
        }
    }

    public static class EndTag
    extends DASLElement {
        private String type = "end_tag";
        private String tag_name;

        public EndTag(String t) {
            this.tag_name = t;
        }

        public String getName() {
            return this.tag_name;
        }

        public void setName(String t) {
            this.tag_name = t;
        }

        public String getType() {
            return this.type;
        }

        public void accept(DASLVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return 3 + this.tag_name.length();
        }

        public String toString() {
            return "</" + this.tag_name + ">";
        }
    }

    public static class StartTag
    extends DASLElement {
        private String type = "start_tag";
        private String tag_name;
        public AttributeList attributeList;

        public StartTag(String t) {
            this.tag_name = t;
        }

        public StartTag(String t, AttributeList a) {
            this.tag_name = t;
            this.attributeList = a;
        }

        public String getName() {
            return this.tag_name;
        }

        public void setName(String t) {
            this.tag_name = t;
        }

        public String getType() {
            return this.type;
        }

        public void accept(DASLVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            int length = 0;
            Enumeration<Attribute> ae = this.attributeList.attributes.elements();
            while (ae.hasMoreElements()) {
                length += 1 + ae.nextElement().getLength();
            }
            return length + this.tag_name.length() + 2;
        }

        public String toString() {
            String s = "<" + this.tag_name;
            Enumeration<Attribute> ae = this.attributeList.attributes.elements();
            while (ae.hasMoreElements()) {
                s = s + " " + ae.nextElement().toString();
            }
            s = s + ">";
            return s;
        }
    }

    public static class Text
    extends DASLElement {
        private String type = "text";
        private String tag_name = "";
        private String content;

        public Text(String s) {
            this.content = s;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.tag_name;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String s) {
            this.content = s;
        }

        public void accept(DASLVisitor v) {
            v.visit(this);
        }

        public int getLength() {
            return this.content.length();
        }

        public String toString() {
            return this.content;
        }
    }

    public static abstract class DASLElement {
        public abstract void accept(DASLVisitor var1);

        public abstract String getType();

        public abstract String getName();
    }
}

