/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.faces.context;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;

public final class HtmlResponseWriter
extends ResponseWriter {
    private Writer writer_;
    private boolean closeStart_;

    public HtmlResponseWriter(Writer writer) {
        this.writer_ = writer;
        this.closeStart_ = false;
    }

    public final void close() throws IOException {
        this.writer_.close();
    }

    public final void flush() throws IOException {
    }

    public final void write(char[] cbuf) throws IOException {
        this.closeStartIfNecessary();
        this.writer_.write(cbuf);
    }

    public final void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.writer_.write(new String(cbuf, off, len));
    }

    public final void write(int c) throws IOException {
        this.closeStartIfNecessary();
        this.writer_.write((char)(c & 0xFFFF));
    }

    public final void write(String s) throws IOException {
        this.closeStartIfNecessary();
        this.writer_.write(s);
    }

    public final void write(String s, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this.writer_.write(s.substring(off, len));
    }

    public String getContentType() {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException();
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public void startElement(String name, UIComponent comp) throws IOException {
        this.closeStartIfNecessary();
        this.writer_.write("<");
        this.writer_.write(name);
        this.closeStart_ = true;
    }

    public void endElement(String name) throws IOException {
        if (this.closeStart_) {
            this.writer_.write("/>");
            this.closeStart_ = false;
        } else {
            this.writer_.write("</");
            this.writer_.write(name);
            this.writer_.write(62);
        }
    }

    public void writeAttribute(String name, Object value, String prop) throws IOException {
        this.writer_.write(32);
        this.writer_.write(name);
        this.writer_.write("=\"");
        this.writer_.write(value.toString());
        this.writer_.write("\"");
    }

    public void writeURIAttribute(String name, Object value) throws IOException {
        this.writer_.write(32);
        this.writer_.write(name);
        this.writer_.write("=\"");
        this.writer_.write(value.toString());
        this.writer_.write("\"");
    }

    public void writeComment(Object comment) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeText(Object text, String prop) throws IOException {
        this.closeStartIfNecessary();
        this.writer_.write(text.toString());
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new HtmlResponseWriter(writer);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.writer_.write(32);
        this.writer_.write(name);
        this.writer_.write("=\"");
        this.writer_.write(value.toString());
        this.writer_.write("\"");
    }

    private void closeStartIfNecessary() throws IOException {
        if (this.closeStart_) {
            this.writer_.write(">");
            this.closeStart_ = false;
        }
    }
}

