/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.servlet.ServletContext;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.SessionManager;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalContainer
extends ExoContainer {
    private static ThreadLocal currentContainer_ = new ThreadLocal();
    private MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer("portalmx");
    private boolean started_ = false;
    private PortalContainerInfo pinfo_;
    private SessionManager smanager_;

    public PortalContainer(PicoContainer parent, ServletContext portalContext) {
        super(new MX4JComponentAdapterFactory(), parent);
        this.registerComponentInstance(ServletContext.class, portalContext);
        this.pinfo_ = new PortalContainerInfo(portalContext);
        this.registerComponentInstance(PortalContainerInfo.class, this.pinfo_);
    }

    public SessionContainer createSessionContainer(String id, String owner) {
        SessionContainer scontainer = this.getSessionManager().getSessionContainer(id);
        if (scontainer != null) {
            this.getSessionManager().removeSessionContainer(id);
        }
        scontainer = new SessionContainer(id, owner);
        scontainer.setPortalName(this.pinfo_.getContainerName());
        this.getSessionManager().addSessionContainer(scontainer);
        SessionContainer.setInstance(scontainer);
        return scontainer;
    }

    public void removeSessionContainer(String sessionID) {
        this.getSessionManager().removeSessionContainer(sessionID);
    }

    public List<SessionContainer> getLiveSessions() {
        return this.getSessionManager().getLiveSessions();
    }

    public SessionManager getSessionManager() {
        if (this.smanager_ == null) {
            this.smanager_ = (SessionManager)this.getComponentInstanceOfType(SessionManager.class);
        }
        return this.smanager_;
    }

    @Override
    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public PortalContainerInfo getPortalContainerInfo() {
        return this.pinfo_;
    }

    public static PortalContainer getInstance() {
        PortalContainer container = (PortalContainer)((Object)currentContainer_.get());
        if (container == null) {
            container = RootContainer.getInstance().getPortalContainer("default");
            currentContainer_.set(container);
        }
        return container;
    }

    public boolean isStarted() {
        return this.started_;
    }

    public void start() {
        super.start();
        this.started_ = true;
    }

    public void stop() {
        super.stop();
        this.started_ = false;
    }

    public synchronized ComponentAdapter getComponentAdapterOfType(Class componentType) {
        return super.getComponentAdapterOfType(componentType);
    }

    public synchronized List getComponentAdaptersOfType(Class componentType) {
        return super.getComponentAdaptersOfType(componentType);
    }

    public synchronized ComponentAdapter unregisterComponent(Object componentKey) {
        return super.unregisterComponent(componentKey);
    }

    public synchronized ComponentAdapter registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        return super.registerComponent(componentAdapter);
    }

    public synchronized List getComponentInstancesOfType(Class componentType) throws PicoException {
        return super.getComponentInstancesOfType(componentType);
    }

    public static void setInstance(PortalContainer instance) {
        currentContainer_.set(instance);
    }

    public static Object getComponent(Class key) {
        PortalContainer pcontainer = (PortalContainer)((Object)currentContainer_.get());
        return pcontainer.getComponentInstanceOfType(key);
    }
}

