/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.backup;

import java.util.Iterator;
import org.exoplatform.xml.object.XMLCollection;
import org.exoplatform.xml.object.XMLEntry;
import org.exoplatform.xml.object.XMLField;
import org.exoplatform.xml.object.XMLMap;
import org.exoplatform.xml.object.XMLObject;
import org.exoplatform.xml.object.XMLValue;

public abstract class XMLObjectConverter {
    private String name;
    private String description;
    private String dataVersion;

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String s) {
        this.description = s;
    }

    public String getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(String s) {
        this.dataVersion = s;
    }

    public void traverse(XMLObject xmlobject) {
        this.update(xmlobject);
        Iterator i = xmlobject.getFieldIterator();
        while (i.hasNext()) {
            XMLField xmlfield = (XMLField)i.next();
            Object obj = xmlfield.getValue();
            if (obj instanceof XMLObject) {
                this.traverse((XMLObject)obj);
                continue;
            }
            if (!(obj instanceof XMLCollection)) continue;
            this.traverse((XMLCollection)obj);
        }
    }

    public void traverse(XMLCollection xmlobject) {
        Iterator i = xmlobject.getIterator();
        while (i.hasNext()) {
            XMLValue xmlvalue = (XMLValue)i.next();
            Object obj = xmlvalue.getValue();
            if (!(obj instanceof XMLObject)) continue;
            this.traverse((XMLObject)obj);
        }
    }

    public void traverse(XMLMap xmlobject) {
        Iterator i = xmlobject.getEntryIterator();
        while (i.hasNext()) {
            Object value;
            XMLEntry xmlentry = (XMLEntry)i.next();
            Object key = xmlentry.getKey().getValue();
            if (key instanceof XMLObject) {
                this.traverse((XMLObject)key);
            }
            if (!((value = xmlentry.getKey().getValue()) instanceof XMLObject)) continue;
            this.traverse((XMLObject)value);
        }
    }

    public abstract void update(XMLObject var1);

    public abstract void pack(XMLObject var1);
}

