/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.chart.impl;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import org.exoplatform.services.chart.Chart;
import org.exoplatform.services.chart.ChartService;
import org.exoplatform.services.chart.Data;
import org.exoplatform.services.chart.ExoCategoryItemLabelGenerator;
import org.exoplatform.services.chart.impl.ChartDownloadResource;
import org.exoplatform.services.download.DownloadResource;
import org.exoplatform.services.download.DownloadService;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class ChartServiceImpl
implements ChartService {
    private DownloadService dservice_;
    private static final String DEFAULT_ID = "chart:/default";

    public ChartServiceImpl(DownloadService downloadservice) throws Exception {
        this.dservice_ = downloadservice;
        ChartDownloadResource defaultChart = new ChartDownloadResource(this.createBlankChart());
        this.dservice_.addDefaultDownloadResource((DownloadResource)defaultChart);
    }

    public BufferedImage createChart(Chart chart) throws Exception {
        if (chart == null || chart.getChartData() == null || chart.getChartData().isEmpty()) {
            return null;
        }
        if (0 == chart.getChartType()) {
            return this.createPieChart(chart);
        }
        if (1 == chart.getChartType()) {
            return this.createBarChart(chart);
        }
        return null;
    }

    public String createDownloadableChart(Chart chart) throws Exception {
        if (chart == null || chart.getChartData() == null || chart.getChartData().isEmpty()) {
            return DEFAULT_ID;
        }
        BufferedImage image = this.createChart(chart);
        ChartDownloadResource cresource = new ChartDownloadResource(image);
        String downloadId = this.dservice_.addDownloadResource((DownloadResource)cresource);
        return downloadId;
    }

    public String creatDownloadableChartLink(Chart chart) throws Exception {
        String chartlink = null;
        if (chart == null || chart.getChartData() == null || chart.getChartData().isEmpty()) {
            chartlink = this.dservice_.getDownloadLink(DEFAULT_ID);
            return chartlink;
        }
        BufferedImage image = this.createChart(chart);
        ChartDownloadResource cresource = new ChartDownloadResource(image);
        String resouceId = this.dservice_.addDownloadResource((DownloadResource)cresource);
        chartlink = this.dservice_.getDownloadLink(resouceId);
        return chartlink;
    }

    public BufferedImage getDownloadableChart(String chartId) throws Exception {
        ChartDownloadResource dresource = (ChartDownloadResource)this.dservice_.getDownloadResource(chartId);
        return dresource.getChartImage();
    }

    private BufferedImage createPieChart(Chart chart) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        for (Data data : chart.getChartData()) {
            dataset.setValue((Comparable)((Object)data.getType()), data.getValue());
        }
        JFreeChart backChart = chart.getIs3DChart() ? ChartFactory.createPieChart3D((String)chart.getChartTitle(), (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false) : ChartFactory.createPieChart((String)chart.getChartTitle(), (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        backChart.setBackgroundPaint((Paint)chart.getBackGroundColor());
        PiePlot plot = (PiePlot)backChart.getPlot();
        plot.setStartAngle(chart.getStartAngle());
        for (Data data : chart.getChartData()) {
            if (data.getDisplayColor() == null) continue;
            plot.setSectionPaint(data.getPainPosition(), (Paint)data.getDisplayColor());
        }
        plot.setDirection(chart.getDirection());
        if (chart.getIsForeGround()) {
            plot.setForegroundAlpha(0.5f);
        }
        return backChart.createBufferedImage(chart.getChartWidth(), chart.getChartHeight());
    }

    private BufferedImage createBarChart(Chart chart) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Data data : chart.getChartData()) {
            dataset.setValue(data.getValue(), (Comparable)((Object)data.getSeries()), (Comparable)((Object)data.getType()));
        }
        PlotOrientation orientation = chart.getIsHorizontal() ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        JFreeChart backChart = chart.getIs3DChart() ? ChartFactory.createBarChart3D((String)chart.getChartTitle(), (String)chart.getCategoryLabel(), (String)chart.getValueLabel(), (CategoryDataset)dataset, (PlotOrientation)orientation, (boolean)true, (boolean)true, (boolean)false) : ChartFactory.createBarChart((String)chart.getChartTitle(), (String)chart.getCategoryLabel(), (String)chart.getValueLabel(), (CategoryDataset)dataset, (PlotOrientation)orientation, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = backChart.getCategoryPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        if (chart.getIsDisplayItemLabel()) {
            renderer.setItemLabelGenerator((CategoryItemLabelGenerator)new ExoCategoryItemLabelGenerator());
            renderer.setItemLabelsVisible(true);
        }
        for (Data data : chart.getChartData()) {
            if (data.getDisplayColor() == null) continue;
            renderer.setSeriesPaint(data.getPainPosition(), (Paint)new GradientPaint(0.0f, 0.0f, data.getDisplayColor(), 0.0f, 0.0f, data.getDisplayColor()));
        }
        return backChart.createBufferedImage(chart.getChartWidth(), chart.getChartHeight());
    }

    private BufferedImage createBlankChart() {
        String errorString = "Insufficient data to generate chart";
        BufferedImage image = new BufferedImage(600, 400, 1);
        Graphics2D offscreen = (Graphics2D)image.getGraphics();
        offscreen.setColor(Color.lightGray);
        offscreen.fillRect(0, 0, 600, 400);
        offscreen.setColor(Color.black);
        offscreen.drawString(errorString, 200, 200);
        return image;
    }
}

