/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.scheduler;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.scheduler.JobInfo;
import org.exoplatform.services.scheduler.PeriodInfo;

public class PeriodJob
extends BaseComponentPlugin {
    private static SimpleDateFormat ft_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private PeriodInfo pjinfo_;
    private JobInfo jinfo_;

    public PeriodJob(InitParams params) throws Exception {
        ExoProperties props = params.getPropertiesParam("job.info").getProperties();
        String jobName = props.getProperty("jobName");
        String jobGroup = props.getProperty("groupName");
        String jobClass = props.getProperty("job");
        Class<?> clazz = Class.forName(jobClass);
        this.jinfo_ = new JobInfo(jobName, jobGroup, clazz);
        Date startTime = this.getDate(props.getProperty("startTime"));
        Date endTime = this.getDate(props.getProperty("endTime"));
        int repeatCount = Integer.parseInt(props.getProperty("repeatCount"));
        long repeatInterval = Integer.parseInt(props.getProperty("period"));
        this.pjinfo_ = new PeriodInfo(startTime, endTime, repeatCount, repeatInterval);
    }

    private Date getDate(String stime) throws Exception {
        Date date = null;
        if (stime == null || stime.equals("")) {
            return date;
        }
        if (stime.startsWith("+")) {
            long val = Long.parseLong(stime.substring(1));
            date = new Date(System.currentTimeMillis() + val);
        } else {
            date = ft_.parse(stime);
        }
        return date;
    }

    public JobInfo getJobInfo() {
        return this.jinfo_;
    }

    public PeriodInfo getPeriodInfo() {
        return this.pjinfo_;
    }
}

