/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.exoplatform.services.document.impl.BaseDocumentReader;

public class XMLDocumentReader
extends BaseDocumentReader {
    public String[] getMimeTypes() {
        return new String[]{"text/xml"};
    }

    public String getContentAsText(InputStream is) throws Exception {
        int len;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = is.read(buffer)) > 0) {
            bos.write(buffer, 0, len);
        }
        bos.close();
        String xml = new String(bos.toByteArray());
        return this.delete(xml);
    }

    public Properties getProperties(InputStream is) throws Exception {
        return new Properties();
    }

    private String delete(String str) {
        try {
            StringBuffer input = new StringBuffer(str);
            String patternString = "<+[^>]*>+";
            Pattern pattern = Pattern.compile(patternString, 34);
            Matcher matcher = pattern.matcher(input);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                input.delete(start, end);
                matcher = pattern.matcher(input);
            }
            return input.substring(0, input.length());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return "";
        }
    }
}

