/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl.diff;

import java.util.List;
import org.exoplatform.services.document.diff.ChangeDelta;
import org.exoplatform.services.document.diff.RevisionVisitor;
import org.exoplatform.services.document.impl.diff.ChunkImpl;
import org.exoplatform.services.document.impl.diff.DeltaImpl;
import org.exoplatform.services.document.impl.diff.DiffServiceImpl;

public class ChangeDeltaImpl
extends DeltaImpl
implements ChangeDelta {
    ChangeDeltaImpl() {
    }

    public ChangeDeltaImpl(ChunkImpl orig, ChunkImpl rev) {
        this.init(orig, rev);
    }

    public void verify(List target) throws Exception {
        if (!this.original.verify(target)) {
            throw new Exception();
        }
        if (this.original.first() > target.size()) {
            throw new Exception("original.first() > target.size()");
        }
    }

    public void applyTo(List target) {
        this.original.applyDelete(target);
        this.revised.applyAdd(this.original.first(), target);
    }

    public void toString(StringBuffer s) {
        this.original.rangeString(s);
        s.append("c");
        this.revised.rangeString(s);
        s.append(DiffServiceImpl.NL);
        this.original.toString(s, "< ", "\n");
        s.append("---");
        s.append(DiffServiceImpl.NL);
        this.revised.toString(s, "> ", "\n");
    }

    public void toRCSString(StringBuffer s, String EOL) {
        s.append("d");
        s.append(this.original.rcsfrom());
        s.append(" ");
        s.append(this.original.size());
        s.append(EOL);
        s.append("a");
        s.append(this.original.rcsto());
        s.append(" ");
        s.append(this.revised.size());
        s.append(EOL);
        this.revised.toString(s, "", EOL);
    }

    public void accept(RevisionVisitor visitor) {
        visitor.visit((ChangeDelta)this);
    }
}

