/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.grammar.wiki.impl;

import java.util.Map;
import org.exoplatform.services.grammar.wiki.WikiContext;
import org.exoplatform.services.grammar.wiki.impl.IntrospectionInfo;
import org.exoplatform.services.grammar.wiki.impl.ParsingContext;
import org.exoplatform.services.grammar.wiki.impl.Token;
import org.exoplatform.services.grammar.wiki.impl.TokenHandler;

public class LinkTokenHandler
extends TokenHandler {
    public Token handleToken(Token parent, Token token, ParsingContext context) {
        int index = -1;
        for (int i = token.start + 1; i < token.end; ++i) {
            if (context.buf_[i] != '>') continue;
            index = i;
            break;
        }
        String text = null;
        String link = null;
        if (index > token.start + 1) {
            text = context.getSubstring(token.start + 1, index - 1);
            link = context.getSubstring(index + 1, token.end - 1);
        } else {
            text = link = context.getSubstring(token.start + 1, token.end - 1);
        }
        WikiContext wikiContext = context.getWikiContext();
        if (wikiContext != null) {
            link = link.trim();
            link = IntrospectionInfo.inspect((Map)wikiContext, link);
            text = text.trim();
            text = IntrospectionInfo.inspect((Map)wikiContext, text);
        }
        StringBuffer b = context.getOutputBuffer();
        b.append("<a href='");
        if (link.charAt(0) == '/') {
            b.append(link);
        } else if (!link.startsWith("http://")) {
            b.append("http://").append(link);
        } else {
            b.append(link);
        }
        b.append("'>").append(text).append("</a>");
        return context.nextToken(token);
    }

    public String[] getHandleableTokenType() {
        return new String[]{"[.+]"};
    }
}

